/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.dependencyresolution;

import io.intino.tara.Language;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramReference;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.NamedReference;
import io.intino.tara.model.Parametrized;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.Rule;
import io.intino.tara.model.constraints.Constraint;
import io.intino.tara.model.rules.CustomRule;
import io.intino.tara.model.rules.composition.ConstraintRule;
import io.intino.tara.model.rules.property.PropertyCustomRule;
import io.intino.tara.model.rules.property.ReferenceRule;
import io.intino.tara.model.rules.property.WordRule;
import io.intino.tara.processors.dependencyresolution.CustomRuleLoader;
import io.intino.tara.processors.dependencyresolution.DependencyException;
import io.intino.tara.processors.dependencyresolution.ReferenceManager;
import io.intino.tara.processors.model.HasMogram;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.model.MogramImpl;
import io.intino.tara.processors.model.ReferenceProperty;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DependencyResolver {
    private final File rulesDirectory;
    private final File semanticLib;
    private final File tempDirectory;
    private final Model model;
    private final ReferenceManager manager;
    private final Map<String, Class<?>> loadedRules = new HashMap();
    private final Language language;
    private final String workingPackage;
    private final List<DependencyException> rulesNotLoaded = new ArrayList<DependencyException>();

    public DependencyResolver(Model model, Language language, String workingPackage, File rulesDirectory, File semanticLib, File tempDirectory) {
        this.model = model;
        this.language = language;
        this.workingPackage = workingPackage;
        this.rulesDirectory = rulesDirectory;
        this.semanticLib = semanticLib;
        this.tempDirectory = tempDirectory;
        this.manager = new ReferenceManager(this.model);
    }

    public void resolve() throws DependencyException {
        for (Mogram m : this.model.mograms()) {
            this.resolveMogramElements(m);
        }
    }

    public List<DependencyException> rulesNotLoaded() {
        return this.rulesNotLoaded;
    }

    private void resolveMogramElements(Mogram mogram) throws DependencyException {
        this.resolve(mogram);
        for (Mogram m : mogram.mograms()) {
            this.resolveMogramElements(m);
        }
    }

    private void resolve(Mogram mogram) throws DependencyException {
        if (!(mogram instanceof MogramImpl)) {
            return;
        }
        this.resolveParent(mogram);
        this.resolveFacetPrescriptions(mogram);
        this.resolveMogramReferences(mogram);
        this.resolveRules(mogram.container(), mogram);
        this.resolveProperties(mogram);
        this.resolveParametersReference(mogram);
    }

    private void resolveFacetPrescriptions(Mogram mogram) throws DependencyException {
        NamedReference<Mogram> facetPrescription = mogram.facetPrescription();
        if (facetPrescription != null && !facetPrescription.resolved()) {
            Mogram resolved = this.manager.resolve(facetPrescription, mogram);
            if (resolved != null) {
                mogram.facetPrescription(resolved);
                NamedReference applied = resolved.applicableFacets().stream().filter(m -> m.reference().equalsIgnoreCase(mogram.qualifiedName())).findFirst().orElse(null);
                if (applied != null) {
                    applied.referent(mogram);
                } else {
                    resolved.addApplicableFacet(mogram);
                }
            } else {
                throw new DependencyException("reject.dependency.reference.mogram.not.found", mogram, new String[0]);
            }
        }
        if (mogram.facetConstraints() == null) {
            return;
        }
        for (Mogram.FacetConstraint c : mogram.facetConstraints()) {
            if (c.target().resolved()) continue;
            Mogram resolvedConstraint = this.manager.resolve(c.target(), mogram);
            if (resolvedConstraint != null) {
                c.target().referent(resolvedConstraint);
                continue;
            }
            throw new DependencyException("reject.dependency.reference.mogram.not.found", mogram, new String[0]);
        }
    }

    private void resolveRules(ElementContainer container, Element element) throws DependencyException {
        if (container == null) {
            return;
        }
        for (Rule<?> rule : container.rulesOf(element)) {
            if (rule instanceof CustomRule) {
                this.loadCustomRule(element, (CustomRule)((Object)rule));
            }
            if (!(rule instanceof ConstraintRule)) continue;
            ConstraintRule cr = (ConstraintRule)rule;
            Constraint c = this.manager.resolve(((ConstraintRule)rule).reference());
            if (c == null) {
                throw new DependencyException("reject.constraint.reference.not.found", element, ((ConstraintRule)rule).reference().reference());
            }
            cr.reference().referent(c);
        }
    }

    private void resolveParametersReference(Parametrized parametrized) {
        for (PropertyDescription parameter : parametrized.parameters()) {
            this.resolveParameterValue((Mogram)parametrized, parameter);
        }
    }

    private void resolveParameterValue(Mogram mogram, PropertyDescription parameter) {
        if (parameter.values().isEmpty() || !this.areReferenceValues(parameter)) {
            return;
        }
        for (Object value : parameter.values()) {
            if (((Primitive.Reference)value).isEmpty()) continue;
            Mogram reference = this.resolveReferenceParameter(mogram, (Primitive.Reference)value);
            if (reference == null) {
                reference = this.searchInMetaModel((Primitive.Reference)value);
            }
            if (reference == null) continue;
            ((Primitive.Reference)value).get().referent(reference);
            parameter.type(Primitive.REFERENCE);
        }
    }

    private Mogram searchInMetaModel(Primitive.Reference value) {
        if (this.language == null || this.language.metaLanguage().isEmpty()) {
            return null;
        }
        MogramRoot lModel = this.language.model();
        if (lModel == null) {
            return null;
        }
        return new ReferenceManager(lModel).resolvePropReference(value, lModel.components().get(0));
    }

    private Mogram resolveReferenceParameter(Mogram mogram, Primitive.Reference value) {
        return this.manager.resolvePropReference(value, mogram);
    }

    private boolean areReferenceValues(PropertyDescription parameter) {
        return parameter.values().get(0) instanceof Primitive.Reference;
    }

    private void resolveParent(Mogram mogram) throws DependencyException {
        if (mogram.parent() != null && !mogram.parent().resolved()) {
            Mogram parent = this.manager.resolveParent(mogram.parent().reference(), this.getMogramContainer(mogram.container()));
            if (parent == null) {
                throw new DependencyException("reject.dependency.parent.mogram.not.found", mogram, new String[0]);
            }
            ((MogramImpl)mogram).parent(parent);
            parent.addChild(mogram);
        }
    }

    private void resolveMogramReferences(Mogram mogram) throws DependencyException {
        for (MogramReference ref : mogram.referenceComponents()) {
            if (!(ref instanceof HasMogram)) continue;
            HasMogram h = (HasMogram)ref;
            this.resolveMogramReference(h);
            this.resolveRules(h.container(), ref);
        }
    }

    private void resolveMogramReference(HasMogram ref) throws DependencyException {
        if (ref.target().resolved()) {
            return;
        }
        Mogram target = this.manager.resolve(ref);
        if (target == null) {
            throw new DependencyException("reject.dependency.reference.mogram.not.found", ref, new String[0]);
        }
        ref.target(target);
    }

    private void resolveProperties(Mogram mogram) throws DependencyException {
        for (Property p : mogram.properties()) {
            if (p instanceof ReferenceProperty) {
                this.resolveProperty((ReferenceProperty)p, mogram);
            }
            if (p.rule(PropertyCustomRule.class) == null) continue;
            this.loadCustomRule(p);
        }
    }

    private void loadCustomRule(Property prop) {
        PropertyCustomRule rule = prop.rule(PropertyCustomRule.class);
        String source = rule.externalClass();
        File classFile = null;
        Class<?> aClass = null;
        if (this.workingPackage == null || this.rulesDirectory == null) {
            this.rulesNotLoaded.add(new DependencyException("impossible.load.rule.class", prop, rule.externalClass(), "Rules directory not found"));
            return;
        }
        try {
            aClass = this.loadedRules.containsKey(source) ? this.loadedRules.get(source) : ((classFile = CustomRuleLoader.compile(rule, this.workingPackage, this.rulesDirectory, this.semanticLib, this.tempDirectory)) != null ? CustomRuleLoader.load(rule, this.workingPackage, this.semanticLib, this.tempDirectory) : CustomRuleLoader.tryAsProvided(rule));
        }
        catch (Exception e) {
            this.rulesNotLoaded.add(new DependencyException("impossible.load.rule.class", prop, rule.externalClass(), e.getMessage()));
            rule.qualifiedName(CustomRuleLoader.composeQualifiedName(this.workingPackage, rule.externalClass()));
        }
        if (aClass == null) {
            this.rulesNotLoaded.add(new DependencyException("impossible.load.rule.class", prop, rule.externalClass()));
            return;
        }
        this.loadedRules.put(source, aClass);
        if (classFile != null) {
            this.model.addRule(source, this.tempDirectory);
        }
        if (prop.type().equals(Primitive.WORD)) {
            this.updateRule(prop, rule, aClass);
        } else {
            rule.setLoadedClass(aClass);
            rule.classFile(classFile);
        }
    }

    private void loadCustomRule(Element element, CustomRule rule) throws DependencyException {
        Class<?> aClass;
        String source = rule.externalClass();
        File classFile = null;
        try {
            aClass = this.loadedRules.containsKey(source) ? this.loadedRules.get(source) : ((classFile = CustomRuleLoader.compile(rule, this.workingPackage, this.rulesDirectory, this.semanticLib, this.tempDirectory)) != null ? CustomRuleLoader.load(rule, this.workingPackage, this.semanticLib, this.tempDirectory) : CustomRuleLoader.tryAsProvided(rule));
        }
        catch (Exception e) {
            this.rulesNotLoaded.add(new DependencyException("impossible.load.rule.class", element, rule.externalClass(), e.getMessage()));
            throw new DependencyException("impossible.load.rule.class", element, rule.externalClass(), e.getMessage().split("\n")[0]);
        }
        if (aClass != null) {
            this.loadedRules.put(source, aClass);
            if (classFile != null) {
                this.model.addRule(source, this.tempDirectory);
            }
            rule.setLoadedClass(aClass);
            rule.classFile(classFile);
        } else {
            this.rulesNotLoaded.add(new DependencyException("impossible.load.rule.class", element, rule.externalClass(), "Class not found"));
        }
    }

    private void updateRule(Property prop, PropertyCustomRule rule, Class<?> aClass) {
        if (aClass != null) {
            prop.rules().remove(rule);
            prop.add(new WordRule(this.collectEnums(Arrays.asList(aClass.getDeclaredFields())), aClass.getSimpleName()));
        }
    }

    private List<String> collectEnums(List<Field> fields) {
        return fields.stream().filter(Field::isEnumConstant).map(Field::getName).collect(Collectors.toList());
    }

    private void resolveProperty(ReferenceProperty prop, Mogram container) throws DependencyException {
        Mogram target = this.manager.resolve(prop, container);
        if (target == null) {
            throw new DependencyException("reject.reference.property.not.found", container, prop.target().reference());
        }
        prop.target().referent(target);
        prop.add(this.createReferenceRule(prop));
        this.resolvePropDefaultValue(prop, container);
    }

    private void resolvePropDefaultValue(ReferenceProperty prop, Mogram container) throws DependencyException {
        if (prop.values().isEmpty() || !(prop.values().get(0) instanceof Primitive.Reference)) {
            return;
        }
        List<Primitive.Reference> references = prop.values().stream().map(v -> (Primitive.Reference)v).toList();
        for (Primitive.Reference r : references) {
            if (r.isEmpty() || r.get().reference() == null) continue;
            Mogram target = this.manager.resolve(r.get(), container);
            if (target == null) {
                throw new DependencyException("reject.reference.property.not.found", container, prop.target().reference());
            }
            r.get().referent(target);
        }
    }

    private ReferenceRule createReferenceRule(ReferenceProperty prop) {
        return new ReferenceRule(this.collectTypes(prop.target().get()));
    }

    private Set<String> collectTypes(Mogram mogram) {
        HashSet<String> set = new HashSet<String>();
        if (!mogram.is(Annotation.Generalization)) {
            set.add(mogram.qualifiedName());
        }
        for (Mogram child : mogram.children()) {
            set.addAll(this.collectTypes(child));
        }
        return set;
    }

    private ElementContainer getMogramContainer(ElementContainer reference) {
        ElementContainer container = reference;
        while (!(container instanceof MogramImpl) && container.container() != null) {
            container = container.container();
        }
        return container;
    }
}

