/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.dependencyresolution;

import io.intino.tara.language.LanguageException;
import io.intino.tara.language.semantics.MessageProvider;
import io.intino.tara.model.Element;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.processors.model.MogramImpl;

public class DependencyException
extends LanguageException {
    private final String message;
    private final transient Element element;
    private final String[] parameters;
    private final int line;

    public DependencyException(String message, Element element, String ... parameters) {
        this.message = message;
        this.element = element;
        this.parameters = parameters;
        this.line = element != null ? element.line() : -1;
    }

    @Override
    public String getMessage() {
        String elementReference = this.element != null && this.element instanceof MogramImpl ? ((Mogram)this.element).qualifiedName() : this.getElement(this.element);
        return "Dependency resolution error in " + elementReference + "; " + this.getCompleteMessage() + " @ line " + this.line + ", column 1.";
    }

    private String getElement(Element element) {
        if (element == null) {
            return "";
        }
        if (element instanceof Property) {
            return "property " + String.valueOf(element);
        }
        if (element instanceof PropertyDescription) {
            return "parameter";
        }
        return element.toString();
    }

    public Element getElement() {
        return this.element;
    }

    public int getLine() {
        return this.line;
    }

    private String getCompleteMessage() {
        return MessageProvider.message(this.message, this.parameters);
    }
}

