/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors;

import io.intino.tara.Language;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticFatalException;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.processors.Checker;
import io.intino.tara.processors.Resolver;
import java.util.ArrayList;
import java.util.List;

public class SemanticAnalyzer {
    private final MogramRoot root;
    private final Resolver resolver;
    private final Checker checker;
    private final List<SemanticException> exceptions;

    public SemanticAnalyzer(MogramRoot root, Language language) {
        this.root = root;
        this.resolver = new Resolver(language);
        this.checker = new Checker(language);
        this.exceptions = new ArrayList<SemanticException>();
    }

    public void analyze() throws SemanticFatalException {
        this.checker.check(this.root);
        this.root.mograms().forEach(this::resolve);
        this.root.mograms().forEach(this::check);
        if (!this.exceptions.isEmpty()) {
            throw new SemanticFatalException(this.exceptions);
        }
    }

    private void resolve(Mogram mogram) {
        this.resolver.resolve(mogram);
        mogram.mograms().forEach(this::resolve);
    }

    private void check(Mogram mogram) {
        block2: {
            try {
                this.checker.check(mogram);
                mogram.mograms().forEach(this::check);
            }
            catch (SemanticFatalException e) {
                this.exceptions.addAll(e.exceptions());
                if (this.hasFatal(e.exceptions())) break block2;
                mogram.components().forEach(this::check);
            }
        }
    }

    private boolean hasFatal(List<SemanticException> exceptions) {
        return exceptions.stream().anyMatch(SemanticException::isFatal);
    }
}

