/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors;

import io.intino.tara.Language;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.processors.dependencyresolution.ReferenceManager;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Resolver {
    private final Language language;

    public Resolver(Language language) {
        this.language = language;
    }

    public static String shortType(String absoluteType) {
        return absoluteType.contains(".") ? absoluteType.substring(absoluteType.lastIndexOf(46) + 1) : absoluteType;
    }

    public void resolve(ElementContainer m) {
        if (this.container(m) == null) {
            return;
        }
        this.resolveMogramContainer(m);
    }

    private void resolveMogramContainer(ElementContainer m) {
        this.resolve(this.container(m));
        List<Constraint> constraints = this.containerConstraints(m);
        if (constraints == null) {
            return;
        }
        for (Constraint constraint : this.components(constraints)) {
            if (!this.resolveComponentConstraint((Mogram)m, constraint)) continue;
            return;
        }
        for (Constraint constraint : this.facetInstantiations(constraints)) {
            if (!this.resolveFacetInstantiationConstraint((Mogram)m, (Constraint.FacetInstantiation)constraint)) continue;
            return;
        }
    }

    private List<Constraint> containerConstraints(ElementContainer mogram) {
        Mogram m;
        List<Constraint> constraints;
        if (mogram == null || this.language == null || mogram instanceof MogramRoot) {
            return Collections.emptyList();
        }
        ElementContainer container = this.container(mogram);
        if (container instanceof MogramRoot) {
            return this.language.constraints("");
        }
        List<Constraint> list = constraints = container instanceof Mogram && Resolver.mainType(m = (Mogram)container) != null ? this.language.constraints(Resolver.mainType(m)) : null;
        if (constraints != null && (this.isComponent(constraints, mogram) || this.isFacetInstance(constraints, mogram))) {
            return constraints;
        }
        return this.findInFacets(mogram);
    }

    private boolean isComponent(List<Constraint> constraints, ElementContainer mogram) {
        return constraints.stream().anyMatch(c -> c instanceof Constraint.Component && (Resolver.shortType(((Constraint.Component)c).type()).equals(Resolver.mainType(mogram)) || ((Constraint.Component)c).type().equals(Resolver.mainType(mogram)) || this.isOneOf((Constraint.Component)c, Resolver.mainType(mogram))));
    }

    private boolean isFacetInstance(List<Constraint> constraints, ElementContainer mogram) {
        String mainType = Resolver.mainType(mogram);
        return constraints.stream().anyMatch(c -> {
            Constraint.FacetInstantiation f;
            return c instanceof Constraint.FacetInstantiation && ((f = (Constraint.FacetInstantiation)c).types().stream().map(Resolver::shortType).anyMatch(t -> t.equals(mainType)) || f.types().contains(mainType));
        });
    }

    private List<Constraint.FacetInstantiation> facetInstantiations(List<Constraint> cs) {
        return cs.stream().filter(c -> c instanceof Constraint.FacetInstantiation).map(c -> (Constraint.FacetInstantiation)c).collect(Collectors.toList());
    }

    private List<Constraint.Component> components(List<Constraint> cs) {
        return cs.stream().filter(c -> c instanceof Constraint.Component).map(c -> (Constraint.Component)c).collect(Collectors.toList());
    }

    private boolean isOneOf(Constraint.Component allow, String type) {
        if (!(allow instanceof Constraint.OneOf)) {
            return false;
        }
        return ((Constraint.OneOf)allow).components().stream().anyMatch(one -> one.type().endsWith("." + type) || one.type().equals(type));
    }

    private List<Constraint> findInFacets(ElementContainer mogram) {
        ElementContainer container = this.container(mogram);
        if (container instanceof Mogram) {
            Mogram m = (Mogram)container;
            for (Facet facet : m.appliedFacets()) {
                List<Constraint> constraints = this.language.constraints(facet.fullType());
                if (constraints == null || !this.isComponent(constraints, mogram)) continue;
                return constraints;
            }
        }
        return List.of();
    }

    private boolean resolveComponentConstraint(Mogram mogram, Constraint constraint) {
        if (!(constraint instanceof Constraint.Component)) {
            return false;
        }
        if (constraint instanceof Constraint.OneOf) {
            return this.checkOneOf(mogram, constraint);
        }
        return this.resolveComponent(mogram, (Constraint.Component)constraint);
    }

    private boolean checkOneOf(Mogram mogram, Constraint c) {
        return ((Constraint.OneOf)c).components().stream().anyMatch(one -> this.resolveComponent(mogram, (Constraint.Component)one));
    }

    private boolean resolveComponent(Mogram mogram, Constraint.Component component) {
        String absoluteType = component.type();
        if (Resolver.mainType(mogram) != null && Resolver.shortType(Resolver.mainType(mogram)).equals(Resolver.shortType(absoluteType))) {
            mogram.type(absoluteType);
            this.assume(mogram);
            Mogram mogramDefinition = this.findMogramDefinition(absoluteType, this.language.model());
            if (mogramDefinition != null) {
                mogram.addMetaMogram(mogramDefinition);
            }
            this.resolveDescriptiveProperties(mogram);
            this.resolveFacets(mogram);
            return true;
        }
        return false;
    }

    private boolean resolveFacetInstantiationConstraint(Mogram mogram, Constraint.FacetInstantiation constraint) {
        List<String> shortTypes = constraint.types().stream().map(Resolver::shortType).toList();
        String type = Resolver.mainType(mogram);
        if (type != null && shortTypes.contains(type)) {
            mogram.type(constraint.types().get(0));
            this.assume(mogram);
            Mogram mogramDefinition = this.findMogramDefinition(constraint.types().get(0), this.language.model());
            if (mogramDefinition != null) {
                mogram.addMetaMogram(mogramDefinition);
            }
            this.resolveFacets(mogram);
            this.resolveDescriptiveProperties(mogram);
            return true;
        }
        return false;
    }

    private void assume(Mogram mogram) {
        if (mogram == null || this.language == null) {
            return;
        }
        Level level = this.language.level(Resolver.mainType(mogram));
        if (level != null) {
            mogram.level(level);
        }
        mogram.types().stream().map(t -> Optional.ofNullable(this.language.assumptions((String)t))).filter(Optional::isPresent).flatMap(Optional::stream).forEach(as -> as.forEach(a -> a.assume(mogram)));
    }

    private String simpleType(Constraint.Facet facet) {
        return facet.type().contains(".") ? facet.type().substring(facet.type().lastIndexOf(".") + 1) : facet.type();
    }

    public static String mainType(ElementContainer e) {
        String string;
        if (e instanceof Mogram) {
            Mogram m = (Mogram)e;
            string = m.types().get(0);
        } else {
            string = "";
        }
        return string;
    }

    private void resolveFacets(Mogram mogram) {
        for (Facet facet : mogram.appliedFacets()) {
            Constraint.Facet constraint = this.facetConstraint(mogram, facet);
            if (constraint == null) continue;
            facet.fullType(constraint.type());
            Mogram metamogram = this.findMogramDefinition(constraint.type(), this.language.model());
            if (metamogram != null) {
                mogram.addMetaMogram(metamogram);
                facet.definition().referent(metamogram);
            }
            List<Constraint.Property> parameterConstraints = constraint.constraints().stream().filter(c -> c instanceof Constraint.Property).map(c -> (Constraint.Property)c).collect(Collectors.toList());
            this.resolveDescriptiveProperties(mogram.parameters(), parameterConstraints, metamogram);
        }
    }

    private void resolveDescriptiveProperties(Mogram mogram) {
        this.resolveDescriptiveProperties(mogram.parameters(), this.descriptivePropConstraints(mogram), Resolver.metaMogram(mogram));
    }

    private void resolveDescriptiveProperties(List<PropertyDescription> props, List<Constraint.Property> constraints, Mogram metamogram) {
        for (PropertyDescription prop : props) {
            Constraint.Property constraint = Resolver.findPropConstraint(constraints, prop);
            if (constraint == null) continue;
            prop.name(constraint.name());
            prop.type(constraint.type());
            prop.facet(constraint.facet());
            prop.definition(this.findDefinition(prop, metamogram));
            if (!prop.rules().isEmpty()) continue;
            constraint.rules().forEach(prop::add);
        }
    }

    private Constraint.Facet facetConstraint(Mogram mogram, Facet facet) {
        return this.language.constraints(Resolver.mainType(mogram)).stream().filter(c -> c instanceof Constraint.Facet && this.simpleType((Constraint.Facet)c).equals(facet.type())).findFirst().orElse(null);
    }

    private List<Constraint.Property> descriptivePropConstraints(Mogram mogram) {
        return this.language.constraints(Resolver.mainType(mogram)).stream().filter(c -> c instanceof Constraint.Property).map(c -> (Constraint.Property)c).collect(Collectors.toList());
    }

    private static Constraint.Property findPropConstraint(List<Constraint.Property> constraints, PropertyDescription prop) {
        return constraints.stream().filter(c -> prop.facet().isEmpty() || c.facet().equals(prop.facet())).filter(c -> c.name().equals(prop.name()) || (prop.name() == null || prop.name().isEmpty()) && c.position() == prop.position()).findFirst().orElse(Resolver.findAll(constraints, prop));
    }

    private static Constraint.Property findAll(List<Constraint.Property> constraints, PropertyDescription prop) {
        return constraints.stream().filter(constraint -> constraint.name().equals(prop.name()) && Resolver.hasFacet(constraint.facet(), prop.container().appliedFacets())).findFirst().orElse(null);
    }

    private static boolean hasFacet(String requiredFacet, List<Facet> facets) {
        return requiredFacet.isEmpty() || facets.stream().anyMatch(facet -> facet.type().equals(requiredFacet));
    }

    public ElementContainer container(ElementContainer mogram) {
        return mogram == null ? null : mogram.container();
    }

    private Property findDefinition(PropertyDescription prop, Mogram mogram) {
        return this.effectiveProperties(mogram).filter(p -> p.name().equals(prop.name())).findFirst().orElse(null);
    }

    private Mogram findMogramDefinition(String absoluteType, MogramRoot model) {
        if (model == null) {
            return null;
        }
        String[] path = absoluteType.split("\\.");
        Mogram root = model.components().stream().filter(m -> m.name().equals(path[0])).findFirst().orElse(null);
        if (root == null) {
            return null;
        }
        if (path.length == 1) {
            return root;
        }
        return ReferenceManager.resolvePathInMogram(path, root);
    }

    protected Stream<Property> effectiveProperties(Mogram mogram) {
        Mogram current;
        if (mogram == null) {
            return Stream.empty();
        }
        LinkedHashMap properties = new LinkedHashMap();
        mogram.properties().forEach(p -> properties.put(p.name(), p));
        Mogram mogram2 = current = mogram.parent() != null ? mogram.parent().get() : null;
        while (current != null) {
            current.properties().forEach(p -> properties.put(p.name(), p));
            current = current.parent() != null ? current.parent().get() : null;
        }
        return properties.values().stream();
    }

    private boolean areNamesake(Mogram mogram, String name) {
        return name.equals(mogram.name());
    }

    private static Mogram metaMogram(Mogram mogram) {
        return mogram.metaMograms().isEmpty() ? null : mogram.metaMograms().get(0);
    }
}

