/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors;

import io.intino.tara.Language;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.constraints.FacetConstraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticFatalException;
import io.intino.tara.language.semantics.errorcollector.SemanticIssue;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.rules.Size;
import io.intino.tara.processors.Resolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Checker {
    private final Language language;
    private final List<SemanticException> exceptions = new ArrayList<SemanticException>();

    public Checker(Language language) {
        this.language = language;
    }

    public void check(ElementContainer mogram) throws SemanticFatalException {
        this.exceptions.clear();
        this.checkConstraints(mogram);
        if (!this.exceptions.isEmpty()) {
            this.recoverErrors();
            if (!this.exceptions.isEmpty()) {
                throw new SemanticFatalException(this.exceptions);
            }
        }
    }

    private void recoverErrors() {
        this.exceptions.removeAll(this.exceptions.stream().filter(e -> e.getIssue().key().equals("required.parameter.in.context") && this.isParameterNotFoundRecoverable(e.getIssue().origin()[0], e.getIssue().parameters().get(0).toString(), e.getIssue().parameters().get(1).toString())).toList());
    }

    private boolean isParameterNotFoundRecoverable(Element element, String name, String type) {
        Mogram mogram = (Mogram)element;
        if (this.language == null || mogram == null || Resolver.mainType(mogram) == null) {
            return false;
        }
        List<Constraint.Facet> facets = this.language.constraints(Resolver.mainType(mogram)).stream().filter(c -> this.sameFacet(mogram, (Constraint)c)).map(c -> (Constraint.Facet)c).toList();
        for (Constraint.Facet facet : facets) {
            for (Constraint.Property c2 : facet.constraints().stream().filter(c -> c instanceof Constraint.Property).map(p -> (Constraint.Property)p).toList()) {
                if (!c2.type().name().equalsIgnoreCase(type) || !c2.name().equals(name) || this.size(c2).isRequired()) continue;
                return true;
            }
        }
        return false;
    }

    private Size size(Constraint.Property c) {
        return c.rules().stream().filter(r -> r instanceof Size).map(r -> (Size)r).findFirst().orElse(null);
    }

    private boolean sameFacet(Mogram mogram, Constraint c) {
        return c instanceof Constraint.Facet && FacetConstraint.findFacet(mogram, ((Constraint.Facet)c).type()) != null;
    }

    private void checkConstraints(ElementContainer m) throws SemanticFatalException {
        if (m == null) {
            throw new SemanticFatalException(new SemanticIssue(SemanticIssue.Level.ERROR, "Mogram is null", (Element)null));
        }
        this.checkMogramConstrains(m);
    }

    private void checkMogramConstrains(ElementContainer elementContainer) throws SemanticFatalException {
        List<Constraint> constraints = this.language.constraints(Resolver.mainType(elementContainer));
        if (constraints == null) {
            throw new SemanticFatalException(new SemanticIssue(SemanticIssue.Level.ERROR, "reject.type.not.exists", elementContainer, Collections.singletonList(this.presentableType(Resolver.mainType(elementContainer)))));
        }
        for (Constraint constraint : constraints) {
            try {
                constraint.check(elementContainer);
            }
            catch (SemanticException e) {
                this.exceptions.add(e);
            }
        }
    }

    private String presentableType(String type) {
        return type.replaceFirst(":", " on ");
    }
}

