/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.rules.property;

import io.intino.tara.model.Primitive;
import io.intino.tara.model.Rule;
import io.intino.tara.model.Valued;
import java.util.Collections;
import java.util.List;

public class WordRule
implements Rule<Valued> {
    private static final long serialVersionUID = 1L;
    private static final String REJECT_INVALID_WORD_VALUES = "reject.invalid.word.values";
    private final List<Object> parameters;
    private final List<String> words;
    private final String aClass;
    private String errorMessage;

    public WordRule(List<String> words) {
        this.words = words;
        this.aClass = null;
        this.parameters = Collections.singletonList(String.join((CharSequence)", ", words));
    }

    public WordRule(List<String> words, String aClass) {
        this.words = words;
        this.aClass = aClass;
        this.parameters = Collections.singletonList(String.join((CharSequence)", ", words));
    }

    public List<String> words() {
        return this.words;
    }

    public boolean isCustom() {
        return this.aClass != null;
    }

    public String externalClass() {
        return this.aClass;
    }

    @Override
    public boolean accept(Valued valued) {
        List<Object> values = valued.values();
        if (this.hasExpressionValue(values)) {
            return true;
        }
        if (!values.stream().map(v -> (Primitive.Reference)v).allMatch(r -> r.isEmpty() || this.words.contains(r.get().reference()))) {
            this.errorMessage = REJECT_INVALID_WORD_VALUES;
            return false;
        }
        if (valued.name().equals(valued.container().name())) {
            this.errorMessage = "reject.invalid.word.name";
            return false;
        }
        if (this.words().isEmpty()) {
            this.errorMessage = "reject.invalid.word.names";
            return false;
        }
        return true;
    }

    @Override
    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    public List<Object> errorParameters() {
        return this.parameters;
    }

    private boolean hasExpressionValue(List<Object> values) {
        return !values.isEmpty() && (values.get(0) instanceof Primitive.Expression || values.get(0) instanceof Primitive.MethodReference);
    }
}

