/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.rules.property;

import io.intino.tara.model.Metric;
import io.intino.tara.model.Rule;
import io.intino.tara.model.Valued;
import io.intino.tara.model.rules.CustomRule;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class PropertyCustomRule
implements CustomRule,
Rule<Valued> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getGlobal();
    private final String aClass;
    private Class<?> loadedClass;
    private Rule<?> object;
    private String qualifiedName;
    private transient File classFile;

    public PropertyCustomRule(String aClass) {
        this.aClass = aClass;
    }

    @Override
    public boolean accept(Valued valued) {
        return this.loadedClass == null || !this.isMetric() && this.invokeWith(valued.values());
    }

    @Override
    public String errorMessage() {
        return "";
    }

    @Override
    public List<Object> errorParameters() {
        return Collections.emptyList();
    }

    public String getDefaultUnit() {
        for (Field field : this.loadedClass.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            return field.getName();
        }
        return null;
    }

    public boolean isMetric() {
        if (this.loadedClass == null || !this.loadedClass.isEnum()) {
            return false;
        }
        for (Class<?> aClass : this.loadedClass.getInterfaces()) {
            if (!aClass.getName().equals(Metric.class.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> loadedClass() {
        return this.loadedClass;
    }

    public String qualifiedName() {
        return this.loadedClass == null ? this.qualifiedName : this.loadedClass.getName();
    }

    @Override
    public void setLoadedClass(Class<?> loadedClass) {
        this.loadedClass = loadedClass;
        try {
            this.object = (Rule)this.loadedClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Override
    public void classFile(File file) {
        this.classFile = file;
    }

    @Override
    public File classFile() {
        return this.classFile;
    }

    @Override
    public String externalClass() {
        return this.aClass;
    }

    private boolean invokeWith(List<Object> values) {
        try {
            Rule rule = (Rule)this.loadedClass.newInstance();
            if (this.acceptAsList(rule)) {
                return rule.accept(values);
            }
            for (Object value : values) {
                if (rule.accept(value)) continue;
                return false;
            }
            return true;
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.severe(e.getMessage());
            return false;
        }
    }

    private boolean acceptAsList(Rule<?> rule) {
        try {
            return rule.getClass().getMethod("accept", List.class) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void qualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }
}

