/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.rules.property;

import io.intino.tara.model.rules.property.FunctionRule;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NativeObjectRule
extends FunctionRule {
    private static final long serialVersionUID = 1L;
    private static final Map<String, String> recognizedClasses = new HashMap<String, String>();
    private final String type;

    public NativeObjectRule(String type) {
        super("", "", Collections.emptyList());
        this.type = type;
    }

    public String declaredType() {
        return this.type;
    }

    public String type() {
        String[] split = this.type.split("<");
        String rest = this.type.substring(split[0].length());
        return recognizedClasses.containsKey(split[0]) ? recognizedClasses.get(split[0]) + rest : this.type;
    }

    @Override
    public String toString() {
        return "NativeObjectRule{" + this.type() + "}";
    }

    static {
        recognizedClasses.put("List", "java.util.List");
        recognizedClasses.put("ArrayList", "java.util.ArrayList");
        recognizedClasses.put("LinkedList", "java.util.LinkedList");
        recognizedClasses.put("Map", "java.util.Map");
        recognizedClasses.put("HashMap", "java.util.HashMap");
        recognizedClasses.put("LinkedHashMap", "java.util.LinkedHashMap");
        recognizedClasses.put("BufferedReader", "java.io.BufferedReader");
        recognizedClasses.put("InputStream", "java.io.InputStream");
        recognizedClasses.put("OutputStream", "java.io.OutputStream");
        recognizedClasses.put("Runnable", "java.lang.Runnable");
    }
}

