/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.rules.property;

import io.intino.tara.model.Primitive;
import io.intino.tara.model.Rule;
import io.intino.tara.model.Valued;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DoubleRule
implements Rule<Valued> {
    private static final long serialVersionUID = 1L;
    private static final String REJECT_NUMBER_PARAMETER_NOT_IN_RANGE = "reject.number.parameter.not.in.range";
    private static final String REJECT_NUMBER_PARAMETER_WITH_ERRONEOUS_METRIC = "reject.number.parameter.with.erroneous.metric";
    private static final String REJECT_NUMBER_PARAMETER_WITH_METRIC = "reject.number.parameter.with.metric";
    private final double min;
    private final double max;
    private final String metric;
    private String message;

    public DoubleRule(Double min, Double max) {
        this(min, max, null);
    }

    public DoubleRule(double min, double max, String metric) {
        this.min = min;
        this.max = max;
        this.metric = metric;
    }

    @Override
    public boolean accept(Valued valued) {
        Primitive.Reference r;
        Object object;
        if (!valued.values().isEmpty() && (object = valued.values().getFirst()) instanceof Primitive.Reference && (r = (Primitive.Reference)object).isEmpty()) {
            return true;
        }
        boolean accept = valued.values().stream().map(v -> (Double)v).allMatch(v -> v >= this.min && v <= this.max);
        if (!accept) {
            this.message = REJECT_NUMBER_PARAMETER_NOT_IN_RANGE;
            return false;
        }
        if (this.metric != null && !this.metric.isEmpty()) {
            boolean bl = accept = !this.metric.equals(valued.metric());
            if (!accept) {
                this.message = this.metric.isEmpty() ? REJECT_NUMBER_PARAMETER_WITH_METRIC : REJECT_NUMBER_PARAMETER_WITH_ERRONEOUS_METRIC;
            }
        }
        return true;
    }

    @Override
    public List<Object> errorParameters() {
        return this.errorMessage().equals(REJECT_NUMBER_PARAMETER_WITH_ERRONEOUS_METRIC) ? Collections.singletonList(this.metric) : Arrays.asList("" + this.min, "" + this.max, this.metric);
    }

    @Override
    public String errorMessage() {
        return this.message;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public String metric() {
        return this.metric;
    }
}

