/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions.functions;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.FunctionCallExpression;
import io.intino.tara.model.constraints.expressions.InvalidExpression;
import io.intino.tara.model.constraints.expressions.functions.FilterFunction;
import java.util.Collection;

public class SumFunction
implements FilterFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isValid(FunctionCallExpression expr) {
        return expr.getNumArguments() >= 1 && expr.getNumArguments() <= 2;
    }

    @Override
    public boolean returnsBoolean(FunctionCallExpression expr) {
        return false;
    }

    @Override
    public Object evaluate(FunctionCallExpression expr, EvaluationContext context) throws Exception {
        Object adding = expr.getArgument(0).evaluate(context);
        if (adding instanceof Collection) {
            Collection c = (Collection)adding;
            return SumFunction.sum(c);
        }
        if (adding instanceof Double) {
            Double d = (Double)adding;
            return d;
        }
        throw new InvalidExpression("Cannot evaluate sum function");
    }

    public static double sum(Collection<?> numbers) {
        double sum = 0.0;
        for (Object num : numbers) {
            if (num instanceof Number) {
                sum += ((Number)num).doubleValue();
                continue;
            }
            throw new IllegalArgumentException("Elemento no num\u00e9rico: " + String.valueOf(num));
        }
        return sum;
    }
}

