/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions.functions;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.FunctionCallExpression;
import io.intino.tara.model.constraints.expressions.functions.FilterFunction;
import java.util.Arrays;

public class SplitFunction
implements FilterFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isValid(FunctionCallExpression expr) {
        return expr.getNumArguments() >= 2 && expr.getNumArguments() <= 3;
    }

    @Override
    public boolean returnsBoolean(FunctionCallExpression expr) {
        return false;
    }

    @Override
    public Object evaluate(FunctionCallExpression expr, EvaluationContext context) throws Exception {
        String src = (String)expr.getArgument(0).evaluate(context);
        String splitPattern = (String)expr.getArgument(1).evaluate(context);
        String[] result = expr.getNumArguments() > 2 ? src.split(splitPattern, (Integer)expr.getArgument(2).evaluate(context)) : src.split(splitPattern);
        return Arrays.asList(result);
    }
}

