/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions.functions;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.FunctionCallExpression;
import io.intino.tara.model.constraints.expressions.functions.FilterFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMatchFunction
implements FilterFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isValid(FunctionCallExpression expr) {
        return expr.getNumArguments() == 2;
    }

    @Override
    public boolean returnsBoolean(FunctionCallExpression expr) {
        return true;
    }

    @Override
    public Object evaluate(FunctionCallExpression expr, EvaluationContext context) throws Exception {
        Object reg = expr.getArgument(0).evaluate(context);
        if (reg != null) {
            String reg_str = reg instanceof String ? (String)reg : reg.toString();
            Object cand = expr.getArgument(1).evaluate(context);
            if (cand != null) {
                Pattern pattern = Pattern.compile(reg_str);
                Matcher matchEng = pattern.matcher(cand instanceof String ? (String)cand : cand.toString());
                return matchEng.find();
            }
        }
        return Boolean.FALSE;
    }
}

