/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions.functions;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.Expression;
import io.intino.tara.model.constraints.expressions.FunctionCallExpression;
import io.intino.tara.model.constraints.expressions.InvalidExpression;
import io.intino.tara.model.constraints.expressions.LambdaExpression;
import io.intino.tara.model.constraints.expressions.functions.FilterFunction;
import io.intino.tara.model.constraints.expressions.functions.LambdaEvaluationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MapFunction
implements FilterFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isValid(FunctionCallExpression expr) {
        return expr.getNumArguments() == 2;
    }

    @Override
    public boolean returnsBoolean(FunctionCallExpression expr) {
        return false;
    }

    @Override
    public Object evaluate(FunctionCallExpression expr, EvaluationContext context) throws Exception {
        Expression expression;
        List<Object> collection = expr.getArgument(0).evaluate(context);
        if (collection == null) {
            throw new InvalidExpression("Cannot resolve '" + expr.getArgument(0).toString() + "'");
        }
        if (!(collection instanceof Collection)) {
            collection = List.of(collection);
        }
        if (!((expression = expr.getArgument(1)) instanceof LambdaExpression)) {
            throw new FunctionCallExpression.InvalidFunctionException(String.valueOf(expr.getArgument(1)) + " is not a lambda expression");
        }
        LambdaExpression lambda = (LambdaExpression)expression;
        ArrayList exceptions = new ArrayList();
        List<Object> list = ((Collection)collection).stream().map(i -> {
            try {
                return MapFunction.apply(context, i, lambda);
            }
            catch (InvalidExpression e) {
                exceptions.add(e);
                return null;
            }
        }).toList();
        if (!exceptions.isEmpty()) {
            throw (Exception)exceptions.getFirst();
        }
        return list;
    }

    private static Object apply(EvaluationContext context, Object element, LambdaExpression lambda) throws InvalidExpression {
        try {
            return lambda.evaluate(new LambdaEvaluationContext(lambda.literal(), element, context));
        }
        catch (Exception e) {
            throw new InvalidExpression(e.getMessage());
        }
    }
}

