/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions.functions;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.FunctionCallExpression;
import io.intino.tara.model.constraints.expressions.functions.FilterFunction;
import java.lang.reflect.Array;
import java.util.Collection;

public class CountFunction
implements FilterFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isValid(FunctionCallExpression expr) {
        return expr.getNumArguments() == 1;
    }

    @Override
    public boolean returnsBoolean(FunctionCallExpression expr) {
        return false;
    }

    @Override
    public Object evaluate(FunctionCallExpression expr, EvaluationContext context) throws Exception {
        Object object = expr.getArgument(0).evaluate(context);
        if (object == null) {
            return 0;
        }
        if (object instanceof Collection) {
            Collection c = (Collection)object;
            return c.size();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        return 1;
    }
}

