/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions.functions;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.BooleanExpression;
import io.intino.tara.model.constraints.expressions.Expression;
import io.intino.tara.model.constraints.expressions.FunctionCallExpression;
import io.intino.tara.model.constraints.expressions.InvalidExpression;
import io.intino.tara.model.constraints.expressions.LambdaExpression;
import io.intino.tara.model.constraints.expressions.functions.FilterFunction;
import io.intino.tara.model.constraints.expressions.functions.LambdaEvaluationContext;
import java.util.Collection;
import java.util.List;

public class AllFunction
implements FilterFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isValid(FunctionCallExpression expr) {
        return expr.getNumArguments() == 2;
    }

    @Override
    public boolean returnsBoolean(FunctionCallExpression expr) {
        return true;
    }

    @Override
    public Object evaluate(FunctionCallExpression expr, EvaluationContext context) throws Exception {
        Expression expression;
        if (!this.isValid(expr)) {
            throw new FunctionCallExpression.InvalidFunctionException("Invalid function call");
        }
        List<Object> collection = expr.getArgument(0).evaluate(context);
        if (collection == null) {
            throw new InvalidExpression("Cannot resolve '" + expr.getArgument(0).toString() + "'");
        }
        if (!(collection instanceof Collection)) {
            collection = List.of(collection);
        }
        if (!((expression = expr.getArgument(1)) instanceof LambdaExpression)) {
            throw new FunctionCallExpression.InvalidFunctionException(String.valueOf(expr.getArgument(1)) + " is not a lambda expression");
        }
        LambdaExpression lambda = (LambdaExpression)expression;
        if (!(lambda.argument() instanceof BooleanExpression)) {
            throw new FunctionCallExpression.InvalidFunctionException(String.valueOf(lambda) + " is not boolean expression");
        }
        return ((Collection)collection).stream().filter(i -> AllFunction.apply(context, i, lambda)).toList();
    }

    private static boolean apply(EvaluationContext context, Object element, LambdaExpression lambda) {
        try {
            return (Boolean)lambda.evaluate(new LambdaEvaluationContext(lambda.literal(), element, context));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

