/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions.binary;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.BinaryExpression;
import io.intino.tara.model.constraints.expressions.BooleanExpression;
import io.intino.tara.model.constraints.expressions.ConstantExpression;
import io.intino.tara.model.constraints.expressions.Expression;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MatchExpression
extends BinaryExpression
implements BooleanExpression {
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;

    public MatchExpression(Expression left, ConstantExpression right, int escape) {
        super(left, right);
        this.pattern = Pattern.compile(right.getValue().toString());
    }

    @Override
    public String getExpressionSymbol() {
        return "matches";
    }

    @Override
    public Object evaluate(EvaluationContext context) throws Exception {
        Object candidate = this.left.evaluate(context);
        if (candidate == null) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(candidate instanceof String ? (String)candidate : candidate.toString());
        return matcher.find();
    }

    @Override
    public boolean matches(EvaluationContext context) throws Exception {
        return this.evaluate(context) == Boolean.TRUE;
    }
}

