/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions.binary;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.BooleanExpression;
import io.intino.tara.model.constraints.expressions.ComparisonExpression;
import io.intino.tara.model.constraints.expressions.Expression;
import io.intino.tara.model.constraints.expressions.UnaryExpression;
import java.util.regex.Pattern;

public class LikeExpression
extends UnaryExpression
implements BooleanExpression {
    private static final long serialVersionUID = 1L;
    Pattern likePattern;

    public LikeExpression(Expression right, String like, int escape) {
        super(right);
        StringBuffer regexp = new StringBuffer(like.length() * 2);
        regexp.append("\\A");
        for (int i = 0; i < like.length(); ++i) {
            char c = like.charAt(i);
            if (escape == (0xFFFF & c) && this.shouldEscapeNext(like, i, c)) {
                char t = like.charAt(++i);
                regexp.append("\\x");
                regexp.append(Integer.toHexString(0xFFFF & t));
                continue;
            }
            this.append(regexp, c);
        }
        regexp.append("\\z");
        this.likePattern = Pattern.compile(regexp.toString(), 32);
    }

    private boolean shouldEscapeNext(String selector, int i, char escape) {
        int next = i + 1;
        if (next < selector.length()) {
            char c = selector.charAt(next);
            return c == '_' || c == '%' || c == escape;
        }
        return false;
    }

    private void append(StringBuffer regexp, char c) {
        if (c == '%') {
            regexp.append(".*?");
        } else if (c == '_') {
            regexp.append(".");
        } else if (ComparisonExpression.REGEXP_CONTROL_CHARS.contains(Character.valueOf(c))) {
            regexp.append("\\x").append(Integer.toHexString(0xFFFF & c));
        } else {
            regexp.append(c);
        }
    }

    @Override
    public String getExpressionSymbol() {
        return "LIKE";
    }

    @Override
    public Object evaluate(EvaluationContext context) throws Exception {
        Object rv = this.getLeft().evaluate(context);
        if (rv == null) {
            return null;
        }
        if (!(rv instanceof String)) {
            return Boolean.FALSE;
        }
        return this.likePattern.matcher((String)rv).matches() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean matches(EvaluationContext context) throws Exception {
        Object object = this.evaluate(context);
        return object == Boolean.TRUE;
    }
}

