/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions.binary;

import io.intino.tara.model.Mogram;
import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.ComparisonExpression;
import io.intino.tara.model.constraints.expressions.Expression;

public class IsExpression
extends ComparisonExpression {
    private static final long serialVersionUID = 1L;

    public IsExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public Object evaluate(EvaluationContext context) throws Exception {
        Object rv;
        Object lv = this.left.evaluate(context);
        if (lv == null ^ (rv = this.right.evaluate(context)) == null) {
            return lv == null ? null : Boolean.FALSE;
        }
        if (lv instanceof Mogram) {
            Mogram m = (Mogram)lv;
            if (rv instanceof String) {
                return m.types().contains(rv) || m.shortType().equals(rv) || m.appliedFacets().stream().anyMatch(f -> f.type().equals(rv));
            }
        }
        if (lv == rv || lv.equals(rv)) {
            return Boolean.TRUE;
        }
        if (lv instanceof Comparable && rv instanceof Comparable) {
            return this.compare((Comparable)lv, (Comparable)rv);
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean matches(EvaluationContext context) throws Exception {
        Object rv;
        Object lv = this.left.evaluate(context);
        if (lv == null ^ (rv = this.right.evaluate(context)) == null) {
            return false;
        }
        if (lv == rv || lv.equals(rv)) {
            return true;
        }
        if (lv.getClass() == rv.getClass()) {
            return false;
        }
        if (lv instanceof Comparable && rv instanceof Comparable) {
            Boolean compareResult = this.compare((Comparable)lv, (Comparable)rv);
            return compareResult != null && compareResult != false;
        }
        return false;
    }

    @Override
    protected boolean asBoolean(int answer) {
        return answer == 0;
    }

    @Override
    public String getExpressionSymbol() {
        return "is";
    }
}

