/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions.binary;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.BinaryExpression;
import io.intino.tara.model.constraints.expressions.BooleanExpression;
import io.intino.tara.model.constraints.expressions.Expression;
import java.util.Collection;
import java.util.List;

public class InExpression
extends BinaryExpression
implements BooleanExpression {
    private static final long serialVersionUID = 1L;

    public InExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public Object evaluate(EvaluationContext context) throws Exception {
        List<Object> leftValue = this.left.evaluate(context);
        List<Object> rightValue = this.right.evaluate(context);
        if (leftValue == null || rightValue == null) {
            return Boolean.FALSE;
        }
        if (!(leftValue instanceof Collection)) {
            leftValue = List.of(leftValue);
        }
        if (!(rightValue instanceof Collection)) {
            rightValue = List.of(rightValue);
        }
        return ((Collection)rightValue).containsAll((Collection)leftValue) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean matches(EvaluationContext context) throws Exception {
        return this.evaluate(context) == Boolean.TRUE;
    }

    @Override
    public String getExpressionSymbol() {
        return "in";
    }
}

