/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.BooleanExpression;
import io.intino.tara.model.constraints.expressions.Expression;
import java.math.BigDecimal;

public abstract class UnaryExpression
implements Expression {
    private static final long serialVersionUID = 1L;
    private static final BigDecimal BD_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    protected Expression left;

    public UnaryExpression(Expression left) {
        this.left = left;
    }

    public static UnaryExpression createNegate(Expression left) {
        return new UnaryExpression(left){

            @Override
            public Object evaluate(EvaluationContext context) throws Exception {
                Object rvalue = this.left.evaluate(context);
                if (rvalue == null) {
                    return null;
                }
                if (rvalue instanceof Number) {
                    return UnaryExpression.negate((Number)rvalue);
                }
                return null;
            }

            @Override
            public String getExpressionSymbol() {
                return "-";
            }
        };
    }

    public static BooleanExpression createNOT(BooleanExpression left) {
        return new NotExpression(left);
    }

    public static BooleanExpression createBooleanCast(Expression left) {
        return new BooleanUnaryExpression(left){

            @Override
            public Object evaluate(EvaluationContext context) throws Exception {
                Object rvalue = this.left.evaluate(context);
                if (rvalue == null) {
                    return null;
                }
                if (!rvalue.getClass().equals(Boolean.class)) {
                    return Boolean.FALSE;
                }
                return (Boolean)rvalue != false ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public String toString() {
                return this.left.toString();
            }

            @Override
            public String getExpressionSymbol() {
                return "";
            }
        };
    }

    private static Number negate(Number left) {
        Class<?> clazz = left.getClass();
        if (clazz == Integer.class) {
            return -left.intValue();
        }
        if (clazz == Long.class) {
            return -left.longValue();
        }
        if (clazz == Float.class) {
            return Float.valueOf(-left.floatValue());
        }
        if (clazz == Double.class) {
            return -left.doubleValue();
        }
        if (clazz == BigDecimal.class) {
            BigDecimal bd = (BigDecimal)left;
            if (BD_LONG_MIN_VALUE.compareTo(bd = bd.negate()) == 0) {
                return Long.MIN_VALUE;
            }
            return bd;
        }
        throw new RuntimeException("Don't know how to negate: " + String.valueOf(left));
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression expression) {
        this.left = expression;
    }

    public String toString() {
        return "(" + this.getExpressionSymbol() + " " + this.left.toString() + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public abstract String getExpressionSymbol();

    private static class NotExpression
    extends BooleanUnaryExpression {
        public NotExpression(BooleanExpression right) {
            super(right);
        }

        @Override
        public Object evaluate(EvaluationContext context) throws Exception {
            Boolean lvalue = (Boolean)this.left.evaluate(context);
            if (lvalue == null) {
                return null;
            }
            return lvalue != false ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public boolean matches(EvaluationContext context) throws Exception {
            Boolean lvalue = (Boolean)this.left.evaluate(context);
            return lvalue != null && lvalue == false;
        }

        @Override
        public String getExpressionSymbol() {
            return "not";
        }
    }

    static abstract class BooleanUnaryExpression
    extends UnaryExpression
    implements BooleanExpression {
        public BooleanUnaryExpression(Expression left) {
            super(left);
        }

        @Override
        public boolean matches(EvaluationContext context) throws Exception {
            return this.evaluate(context) == Boolean.TRUE;
        }
    }
}

