/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.Expression;
import io.intino.tara.model.constraints.expressions.functions.BuiltinFunctionRegistry;
import io.intino.tara.model.constraints.expressions.functions.FilterFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FunctionCallExpression
implements Expression {
    private static final long serialVersionUID = 1L;
    protected static final Map<String, FunctionRegistration> functionRegistry = new HashMap<String, FunctionRegistration>();
    protected String functionName;
    protected List<Expression> arguments;
    protected FilterFunction function;

    public static List<String> registeredFunctions() {
        return new ArrayList<String>(functionRegistry.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerFunction(String name, FilterFunction function) {
        boolean result = true;
        Map<String, FunctionRegistration> map = functionRegistry;
        synchronized (map) {
            if (functionRegistry.containsKey(name)) {
                result = false;
            } else {
                functionRegistry.put(name, new FunctionRegistration(function));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterFunction(String name) {
        Map<String, FunctionRegistration> map = functionRegistry;
        synchronized (map) {
            functionRegistry.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionCallExpression(String function, List<Expression> args) throws InvalidFunctionException {
        FunctionRegistration registry;
        Map<String, FunctionRegistration> map = functionRegistry;
        synchronized (map) {
            registry = functionRegistry.get(function);
        }
        if (registry != null) {
            this.arguments = new ArrayList<Expression>();
            this.arguments.addAll(args);
            this.functionName = function;
            this.function = registry.getFilterFunction();
            if (!this.function.isValid(this)) {
                throw new InvalidFunctionException("invalid function " + function);
            }
        } else {
            throw new InvalidFunctionException("invalid function name, \"" + function + "\"");
        }
    }

    public int getNumArguments() {
        return this.arguments.size();
    }

    public Expression getArgument(int which) {
        return this.arguments.get(which);
    }

    public List<Expression> arguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public Object evaluate(EvaluationContext context) throws Exception {
        return this.function.evaluate(this, context);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.functionName).append("(");
        boolean first_f = true;
        for (Expression arg : this.arguments) {
            if (first_f) {
                first_f = false;
            } else {
                result.append(", ");
            }
            result.append(arg.toString());
        }
        result.append(")");
        return result.toString();
    }

    static {
        BuiltinFunctionRegistry.register();
    }

    protected static class FunctionRegistration {
        protected FilterFunction filterFunction;

        public FunctionRegistration(FilterFunction func) {
            this.filterFunction = func;
        }

        public FilterFunction getFilterFunction() {
            return this.filterFunction;
        }
    }

    public static class InvalidFunctionException
    extends Exception {
        public InvalidFunctionException(String msg) {
            super(msg);
        }
    }
}

