/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.BooleanExpression;
import io.intino.tara.model.constraints.expressions.Expression;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;

public class ConstantExpression
implements Expression {
    private static final long serialVersionUID = 1L;
    public static final BooleanConstantExpression EMTPY = new BooleanConstantExpression(null);
    private final Object value;

    public ConstantExpression(Object value) {
        this.value = value;
    }

    public static ConstantExpression createFromDecimal(String text) {
        Number value;
        if (text.endsWith("l") || text.endsWith("L")) {
            text = text.substring(0, text.length() - 1);
        }
        try {
            value = Long.valueOf(text);
        }
        catch (NumberFormatException e) {
            value = new BigDecimal(text);
        }
        long l = value.longValue();
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            value = value.intValue();
        }
        return new ConstantExpression(value);
    }

    public static ConstantExpression createFromHex(String text) {
        Number value = Long.parseLong(text.substring(2), 16);
        long l = value;
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            value = ((Number)value).intValue();
        }
        return new ConstantExpression(value);
    }

    public static ConstantExpression createFromOctal(String text) {
        Number value = Long.parseLong(text, 8);
        long l = value;
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            value = ((Number)value).intValue();
        }
        return new ConstantExpression(value);
    }

    public static ConstantExpression createFloat(String text) {
        Double value = Double.valueOf(text);
        return new ConstantExpression(value);
    }

    @Override
    public Object evaluate(EvaluationContext context) throws Exception {
        return this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        Object object = this.value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, String.class}, (Object)object, n)) {
            case -1 -> "empty";
            case 0 -> {
                Boolean b = (Boolean)object;
                if (b.booleanValue()) {
                    yield "true";
                }
                yield "false";
            }
            case 1 -> {
                String s = (String)object;
                yield ConstantExpression.encodeString(s);
            }
            default -> this.value.toString();
        };
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public static String encodeString(String s) {
        StringBuilder b = new StringBuilder();
        b.append('\'');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                b.append(c);
            }
            b.append(c);
        }
        b.append('\'');
        return b.toString();
    }

    static class BooleanConstantExpression
    extends ConstantExpression
    implements BooleanExpression {
        public BooleanConstantExpression(Object value) {
            super(value);
        }

        @Override
        public boolean matches(EvaluationContext context) throws Exception {
            Object object = this.evaluate(context);
            return object == Boolean.TRUE;
        }
    }
}

