/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.expressions;

import io.intino.tara.model.constraints.context.EvaluationContext;
import io.intino.tara.model.constraints.expressions.BinaryExpression;
import io.intino.tara.model.constraints.expressions.BooleanExpression;
import io.intino.tara.model.constraints.expressions.ConstantExpression;
import io.intino.tara.model.constraints.expressions.Expression;
import io.intino.tara.model.constraints.expressions.FunctionCallExpression;
import io.intino.tara.model.constraints.expressions.InvalidExpression;
import io.intino.tara.model.constraints.expressions.PropertyExpression;
import io.intino.tara.model.constraints.expressions.UnaryExpression;
import io.intino.tara.model.constraints.expressions.binary.EqualsExpression;
import io.intino.tara.model.constraints.expressions.binary.InExpression;
import io.intino.tara.model.constraints.expressions.binary.IsExpression;
import io.intino.tara.model.constraints.expressions.binary.LikeExpression;
import io.intino.tara.model.constraints.expressions.binary.MatchExpression;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class ComparisonExpression
extends BinaryExpression
implements BooleanExpression,
Serializable {
    private static final long serialVersionUID = 1L;
    transient boolean convertStringExpressions = true;
    public static final Set<Character> REGEXP_CONTROL_CHARS = new HashSet<Character>();

    public ComparisonExpression(Expression left, Expression right) {
        super(left, right);
    }

    public static BooleanExpression createStartsWith(Expression left, String right, String escape, boolean negated) throws InvalidExpression {
        return ComparisonExpression.createLike(left, right + "%", escape, negated);
    }

    public static BooleanExpression createLike(Expression left, String right, String escape, boolean negated) throws InvalidExpression {
        if (escape != null && escape.length() != 1) {
            throw ComparisonExpression.error("The ESCAPE string literal is invalid.  It can only be one character.  Literal used: " + escape);
        }
        int c = -1;
        if (escape != null) {
            c = 0xFFFF & escape.charAt(0);
        }
        LikeExpression expression = new LikeExpression(left, right, c);
        return negated ? UnaryExpression.createNOT(expression) : expression;
    }

    public static BooleanExpression createMatch(Expression left, ConstantExpression right, String escape, boolean negated) throws InvalidExpression {
        if (escape != null && escape.length() != 1) {
            throw ComparisonExpression.error("The ESCAPE string literal is invalid.  It can only be one character.  Literal used: " + escape);
        }
        int c = -1;
        if (escape != null) {
            c = 0xFFFF & escape.charAt(0);
        }
        MatchExpression expression = new MatchExpression(left, right, c);
        return negated ? UnaryExpression.createNOT(expression) : expression;
    }

    public static BooleanExpression createInFilter(Expression left, Expression right, boolean negated) throws InvalidExpression {
        if (!(left instanceof PropertyExpression)) {
            throw ComparisonExpression.error("Expected a property for In expression, got: " + String.valueOf(left));
        }
        if (right instanceof PropertyExpression) {
            PropertyExpression rightP = (PropertyExpression)right;
            return ComparisonExpression.createInExpression((PropertyExpression)left, rightP, negated);
        }
        if (right instanceof FunctionCallExpression) {
            FunctionCallExpression c = (FunctionCallExpression)right;
            return ComparisonExpression.createInExpression((PropertyExpression)left, c, negated);
        }
        throw ComparisonExpression.error("Expected a property for In expression, got: " + String.valueOf(right));
    }

    public static BooleanExpression createIs(Expression left, Expression right, boolean negated) throws InvalidExpression {
        IsExpression expression = new IsExpression(left, right);
        if (!(right instanceof ConstantExpression)) {
            throw new InvalidExpression("'is' operator expects an String as second parameter");
        }
        return negated ? UnaryExpression.createNOT(expression) : expression;
    }

    public static BooleanExpression createInExpression(PropertyExpression left, Expression container, boolean negated) {
        InExpression expression = new InExpression(left, container);
        return negated ? UnaryExpression.createNOT(expression) : expression;
    }

    public static BooleanExpression createEqual(Expression left, Expression right, boolean negated) throws InvalidExpression {
        return negated ? UnaryExpression.createNOT(ComparisonExpression.createEqual(left, right)) : ComparisonExpression.createEqual(left, right);
    }

    private static InvalidExpression error(String left) {
        return new InvalidExpression(left);
    }

    public static BooleanExpression createEqual(Expression left, Expression right) throws InvalidExpression {
        ComparisonExpression.checkEqualOperand(left);
        ComparisonExpression.checkEqualOperand(right);
        ComparisonExpression.checkEqualOperandCompatability(left, right);
        return ComparisonExpression.doCreateEqual(left, right);
    }

    private static BooleanExpression doCreateEqual(Expression left, Expression right) {
        return new EqualsExpression(left, right);
    }

    public static BooleanExpression createGreaterThan(Expression left, Expression right) throws InvalidExpression {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new GreaterThan(left, right);
    }

    public static BooleanExpression createGreaterThanEqual(Expression left, Expression right) throws InvalidExpression {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new GreaterThanEqual(left, right);
    }

    public static BooleanExpression createLessThan(Expression left, Expression right) throws InvalidExpression {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new LessThan(left, right);
    }

    public static BooleanExpression createLessThanEqual(Expression left, Expression right) throws InvalidExpression {
        ComparisonExpression.checkLessThanOperand(left);
        ComparisonExpression.checkLessThanOperand(right);
        return new LessThanEqual(left, right);
    }

    public static void checkLessThanOperand(Expression expr) throws InvalidExpression {
        if (expr instanceof ConstantExpression) {
            Object value = ((ConstantExpression)expr).getValue();
            if (value instanceof Number || value instanceof String) {
                return;
            }
            throw ComparisonExpression.error("Value '" + String.valueOf(expr) + "' cannot be compared.");
        }
        if (expr instanceof BooleanExpression) {
            throw ComparisonExpression.error("Value '" + String.valueOf(expr) + "' cannot be compared.");
        }
    }

    public static void checkEqualOperand(Expression expr) throws InvalidExpression {
        Object value;
        if (expr instanceof ConstantExpression && (value = ((ConstantExpression)expr).getValue()) == null) {
            throw ComparisonExpression.error("'" + String.valueOf(expr) + "' cannot be compared.");
        }
    }

    private static void checkEqualOperandCompatability(Expression left, Expression right) throws InvalidExpression {
        if (left instanceof ConstantExpression && right instanceof ConstantExpression && left instanceof BooleanExpression && !(right instanceof BooleanExpression)) {
            throw ComparisonExpression.error("'" + String.valueOf(left) + "' cannot be compared with '" + String.valueOf(right) + "'");
        }
    }

    @Override
    public Object evaluate(EvaluationContext context) throws Exception {
        Object left = this.left.evaluate(context);
        if (left == null) {
            return false;
        }
        if (left instanceof Collection) {
            throw ComparisonExpression.error("Collections cannot be compared in this way");
        }
        if (!(left instanceof Comparable)) {
            throw ComparisonExpression.error("Collections cannot be compared in this way");
        }
        Object rv = this.right.evaluate(context);
        if (rv == null) {
            return false;
        }
        return this.compare((Comparable)left, (Comparable)rv);
    }

    protected Boolean compare(Comparable lv, Comparable rv) {
        block46: {
            Class<?> rc;
            Class<?> lc = lv.getClass();
            if (lc != (rc = rv.getClass())) {
                try {
                    if (lc == Boolean.class) {
                        if (this.convertStringExpressions && rc == String.class) {
                            lv = Boolean.valueOf(lv.toString());
                            break block46;
                        }
                        return Boolean.FALSE;
                    }
                    if (lc == Byte.class) {
                        if (rc == Short.class) {
                            lv = Short.valueOf(((Number)((Object)lv)).shortValue());
                            break block46;
                        }
                        if (rc == Integer.class) {
                            lv = Integer.valueOf(((Number)((Object)lv)).intValue());
                            break block46;
                        }
                        if (rc == Long.class) {
                            lv = Long.valueOf(((Number)((Object)lv)).longValue());
                            break block46;
                        }
                        if (rc == Float.class) {
                            lv = Float.valueOf(((Number)((Object)lv)).floatValue());
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = Double.valueOf(((Number)((Object)lv)).doubleValue());
                            break block46;
                        }
                        if (this.convertStringExpressions && rc == String.class) {
                            rv = Byte.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return Boolean.FALSE;
                    }
                    if (lc == Short.class) {
                        if (rc == Integer.class) {
                            lv = Integer.valueOf(((Number)((Object)lv)).intValue());
                            break block46;
                        }
                        if (rc == Long.class) {
                            lv = Long.valueOf(((Number)((Object)lv)).longValue());
                            break block46;
                        }
                        if (rc == Float.class) {
                            lv = Float.valueOf(((Number)((Object)lv)).floatValue());
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = Double.valueOf(((Number)((Object)lv)).doubleValue());
                            break block46;
                        }
                        if (this.convertStringExpressions && rc == String.class) {
                            rv = Short.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return Boolean.FALSE;
                    }
                    if (lc == Integer.class) {
                        if (rc == Long.class) {
                            lv = Long.valueOf(((Number)((Object)lv)).longValue());
                            break block46;
                        }
                        if (rc == Float.class) {
                            lv = Float.valueOf(((Number)((Object)lv)).floatValue());
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = Double.valueOf(((Number)((Object)lv)).doubleValue());
                            break block46;
                        }
                        if (this.convertStringExpressions && rc == String.class) {
                            rv = Integer.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return Boolean.FALSE;
                    }
                    if (lc == Long.class) {
                        if (rc == Integer.class) {
                            rv = Long.valueOf(((Number)((Object)rv)).longValue());
                            break block46;
                        }
                        if (rc == Float.class) {
                            lv = Float.valueOf(((Number)((Object)lv)).floatValue());
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = Double.valueOf(((Number)((Object)lv)).doubleValue());
                            break block46;
                        }
                        if (this.convertStringExpressions && rc == String.class) {
                            rv = Long.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return Boolean.FALSE;
                    }
                    if (lc == Float.class) {
                        if (rc == Integer.class) {
                            rv = Float.valueOf(((Number)((Object)rv)).floatValue());
                            break block46;
                        }
                        if (rc == Long.class) {
                            rv = Float.valueOf(((Number)((Object)rv)).floatValue());
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = Double.valueOf(((Number)((Object)lv)).doubleValue());
                            break block46;
                        }
                        if (this.convertStringExpressions && rc == String.class) {
                            rv = Float.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return Boolean.FALSE;
                    }
                    if (lc == Double.class) {
                        if (rc == Integer.class) {
                            rv = Double.valueOf(((Number)((Object)rv)).doubleValue());
                            break block46;
                        }
                        if (rc == Long.class) {
                            rv = Double.valueOf(((Number)((Object)rv)).doubleValue());
                            break block46;
                        }
                        if (rc == Float.class) {
                            rv = Float.valueOf(((Number)((Object)rv)).floatValue());
                            break block46;
                        }
                        if (this.convertStringExpressions && rc == String.class) {
                            rv = Double.valueOf((String)((Object)rv));
                            break block46;
                        }
                        return Boolean.FALSE;
                    }
                    if (this.convertStringExpressions && lc == String.class) {
                        if (rc == Boolean.class) {
                            lv = Boolean.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Byte.class) {
                            lv = Byte.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Short.class) {
                            lv = Short.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Integer.class) {
                            lv = Integer.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Long.class) {
                            lv = Long.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Float.class) {
                            lv = Float.valueOf((String)((Object)lv));
                            break block46;
                        }
                        if (rc == Double.class) {
                            lv = Double.valueOf((String)((Object)lv));
                            break block46;
                        }
                        return Boolean.FALSE;
                    }
                    return Boolean.FALSE;
                }
                catch (NumberFormatException e) {
                    return Boolean.FALSE;
                }
            }
        }
        return this.asBoolean(lv.compareTo(rv)) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected abstract boolean asBoolean(int var1);

    @Override
    public boolean matches(EvaluationContext context) throws Exception {
        return this.evaluate(context) == Boolean.TRUE;
    }

    static {
        REGEXP_CONTROL_CHARS.add(Character.valueOf('.'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('\\'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('['));
        REGEXP_CONTROL_CHARS.add(Character.valueOf(']'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('^'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('$'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('?'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('*'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('+'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('{'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('}'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('|'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('('));
        REGEXP_CONTROL_CHARS.add(Character.valueOf(')'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf(':'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('&'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('<'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('>'));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('='));
        REGEXP_CONTROL_CHARS.add(Character.valueOf('!'));
    }

    private static class GreaterThan
    extends ComparisonExpression {
        public GreaterThan(Expression left, Expression right) {
            super(left, right);
        }

        @Override
        protected boolean asBoolean(int answer) {
            return answer > 0;
        }

        @Override
        public String getExpressionSymbol() {
            return ">";
        }
    }

    private static class GreaterThanEqual
    extends ComparisonExpression {
        public GreaterThanEqual(Expression left, Expression right) {
            super(left, right);
        }

        @Override
        protected boolean asBoolean(int answer) {
            return answer >= 0;
        }

        @Override
        public String getExpressionSymbol() {
            return ">=";
        }
    }

    private static class LessThan
    extends ComparisonExpression {
        public LessThan(Expression left, Expression right) {
            super(left, right);
        }

        @Override
        protected boolean asBoolean(int answer) {
            return answer < 0;
        }

        @Override
        public String getExpressionSymbol() {
            return "<";
        }
    }

    private static class LessThanEqual
    extends ComparisonExpression {
        public LessThanEqual(Expression left, Expression right) {
            super(left, right);
        }

        @Override
        protected boolean asBoolean(int answer) {
            return answer <= 0;
        }

        @Override
        public String getExpressionSymbol() {
            return "<=";
        }
    }
}

