/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints.context;

import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.constraints.context.EvaluationContext;
import java.util.List;

public class MogramContext
implements EvaluationContext {
    private final Mogram mogram;

    public MogramContext(Mogram mogram) {
        this.mogram = mogram;
    }

    @Override
    public Object getProperty(String name) {
        PropertyDescription parameter = this.mogram.parameters().stream().filter(p -> p.name().equals(name)).findFirst().orElse(null);
        if (parameter != null) {
            List<Object> values = parameter.values();
            if (values.isEmpty()) {
                return null;
            }
            if (values.size() == 1) {
                return MogramContext.mapPropertyValue(values.getFirst(), parameter);
            }
            return values.stream().map(v -> MogramContext.mapPropertyValue(v, parameter)).toList();
        }
        if (name.equals("self")) {
            return this.mogram;
        }
        if (!this.mogram.component(name).isEmpty()) {
            return this.mogram.component(name);
        }
        return this.mogram.appliedFacets().stream().filter(f -> f.type().equals(name)).findFirst().orElse(null);
    }

    private static Object mapPropertyValue(Object value, PropertyDescription property) {
        if (value instanceof Primitive.Reference) {
            Primitive.Reference reference = (Primitive.Reference)value;
            if (reference.isEmpty()) {
                return null;
            }
            return property.type() == null || property.type().equals(Primitive.WORD) ? reference.get().reference() : reference.get().get();
        }
        return value;
    }
}

