/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model.constraints;

import io.intino.tara.model.Element;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.constraints.context.MogramContext;
import io.intino.tara.model.constraints.expressions.Expression;
import java.net.URI;

public class Constraint
implements Element {
    private static final long serialVersionUID = 7700837726655946516L;
    private final URI source;
    private final String name;
    private final String message;
    private final Element.TextRange range;
    private Expression expression;

    public Constraint(URI source, String name, String message, Element.TextRange range) {
        this.source = source;
        this.name = name;
        this.message = message;
        this.range = range;
    }

    public String name() {
        return this.name;
    }

    public String message() {
        return this.message;
    }

    public Expression expression() {
        return this.expression;
    }

    public void expression(Expression expression) {
        this.expression = expression;
    }

    public Boolean evaluate(Mogram mogram) throws Exception {
        return (Boolean)this.expression.evaluate(new MogramContext(mogram));
    }

    @Override
    public URI source() {
        return this.source;
    }

    @Override
    public int line() {
        return this.textRange().startLine();
    }

    @Override
    public Element.TextRange textRange() {
        return this.range;
    }

    @Override
    public String doc() {
        return "";
    }
}

