/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model;

import io.intino.tara.model.Annotation;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Valued;
import io.intino.tara.model.rules.Size;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Property
extends Valued,
Cloneable {
    @Override
    public String name();

    @Override
    public Primitive type();

    public boolean isReference();

    @Override
    public Mogram container();

    default public void container(Mogram container) {
    }

    @Override
    default public boolean isMultiple() {
        return this.sizeRule().max() > 1;
    }

    private Size sizeRule() {
        return (Size)this.rules().stream().filter(r -> r instanceof Size).findFirst().get();
    }

    public void type(Primitive var1);

    public void addAnnotations(Annotation ... var1);

    public List<Annotation> annotations();

    public Property overriden();

    public Property overrides();

    public void overriden(Property var1);

    public void overrides(Property var1);

    @Override
    default public void values(List<Object> values) {
    }

    @Override
    public String metric();

    public void metric(String var1);

    public String getUID();

    default public String language() {
        return this.container() == null ? null : this.container().languageName();
    }

    default public Property cloneIt(Mogram container) {
        return null;
    }

    public static class NativeCounter {
        private static final Map<String, Integer> map = new HashMap<String, Integer>();

        public static synchronized int next(ElementContainer container, String name) {
            String key;
            map.put(key, map.containsKey(key = NativeCounter.calculatePackage(container) + "." + name) ? map.get(key) + 1 : 0);
            return map.get(key);
        }

        private static String calculatePackage(ElementContainer container) {
            Mogram mogramContainer = (Mogram)NativeCounter.firstNamedContainer(container);
            return mogramContainer == null ? "" : mogramContainer.qualifiedName().replace("$", ".").replace("#", ".").toLowerCase();
        }

        private static ElementContainer firstNamedContainer(ElementContainer container) {
            List<ElementContainer> containers = NativeCounter.collectStructure(container);
            ElementContainer candidate = null;
            for (ElementContainer mogramContainer : containers) {
                if (mogramContainer instanceof Mogram && !((Mogram)mogramContainer).isAnonymous()) {
                    candidate = mogramContainer;
                    continue;
                }
                if (mogramContainer instanceof Mogram) break;
                candidate = mogramContainer;
            }
            return candidate;
        }

        private static List<ElementContainer> collectStructure(ElementContainer container) {
            ArrayList<ElementContainer> containers = new ArrayList<ElementContainer>();
            for (ElementContainer current = container; current != null && !(current instanceof MogramRoot); current = current.container()) {
                containers.add(0, current);
            }
            return containers;
        }
    }
}

