/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model;

import io.intino.tara.model.EmptyMogram;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.NamedReference;
import io.intino.tara.model.Rule;
import io.intino.tara.model.rules.property.InstantRule;
import io.intino.tara.model.rules.property.TimeRule;
import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum Primitive implements Serializable
{
    INTEGER{

        public List<Integer> convert(String ... value) {
            return Arrays.stream(value).map(Integer::valueOf).collect(Collectors.toList());
        }
    }
    ,
    LONG{

        public List<Long> convert(String ... value) {
            return Arrays.stream(value).map(Long::valueOf).collect(Collectors.toList());
        }
    }
    ,
    DOUBLE{

        public List<Double> convert(String ... value) {
            return Arrays.stream(value).map(Double::valueOf).collect(Collectors.toList());
        }
    }
    ,
    BOOLEAN{

        public List<Boolean> convert(String ... value) {
            return Arrays.stream(value).map(Boolean::valueOf).collect(Collectors.toList());
        }
    }
    ,
    STRING{

        public List<String> convert(String ... value) {
            return Arrays.asList(value);
        }
    }
    ,
    RESOURCE{

        public List<File> convert(String ... value) {
            return Arrays.stream(value).map(File::new).collect(Collectors.toList());
        }
    }
    ,
    REFERENCE,
    WORD,
    FUNCTION,
    OBJECT,
    DATE,
    TIME{

        public TimeRule defaultRule() {
            return new TimeRule();
        }
    }
    ,
    INSTANT{

        public List<Long> convert(String ... value) {
            ArrayList<Long> list = new ArrayList<Long>();
            for (String o : value) {
                list.add(Instant.parse(o).toEpochMilli());
            }
            return list;
        }

        public InstantRule defaultRule() {
            return new InstantRule();
        }
    }
    ,
    EMPTY;


    public List<?> convert(String ... value) {
        return Arrays.asList(value);
    }

    public Rule<?> defaultRule() {
        return null;
    }

    public List<String> convert(Object ... value) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object o : value) {
            values.add(o.toString());
        }
        return values;
    }

    public static Primitive value(String value) {
        try {
            return Primitive.valueOf(Primitive.class, value.toUpperCase().replaceAll("x|X", ""));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getName() {
        return Primitive.capitalize(super.name());
    }

    public String javaName() {
        return Primitive.capitalize(super.name());
    }

    private static String capitalize(String type) {
        return type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase();
    }

    public static List<Primitive> getPrimitives() {
        ArrayList<Primitive> list = new ArrayList<Primitive>();
        list.add(INTEGER);
        list.add(LONG);
        list.add(DOUBLE);
        list.add(BOOLEAN);
        list.add(STRING);
        list.add(FUNCTION);
        list.add(WORD);
        list.add(OBJECT);
        list.add(TIME);
        list.add(DATE);
        list.add(INSTANT);
        list.add(RESOURCE);
        return list;
    }

    public static boolean isPrimitive(String value) {
        for (Primitive primitive : Primitive.getPrimitives()) {
            if (!primitive.getName().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJavaPrimitive(String value) {
        for (Primitive primitive : Primitive.getPrimitives()) {
            if (!primitive.getName().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static class MethodReference
    implements Serializable {
        private final String target;
        private String service;

        public MethodReference(String target) {
            this.target = target;
        }

        public void service(String service) {
            this.service = service;
        }

        public String service() {
            return this.service;
        }

        public String target() {
            return this.target;
        }

        public String toString() {
            return "@" + this.target;
        }
    }

    public static class Reference
    implements Serializable {
        private final NamedReference<Mogram> target;
        private boolean isToInstance = false;
        private List<String> declarationTypes = new ArrayList<String>();
        private String path;

        public Reference(String value) {
            this.target = new NamedReference(value);
        }

        public Reference(Mogram reference) {
            this.target = reference == null ? new NamedReference(null) : new NamedReference<Mogram>(reference, reference.name());
        }

        public NamedReference<Mogram> get() {
            return this.target;
        }

        public List<String> instanceTypes() {
            return this.declarationTypes;
        }

        public boolean isEmpty() {
            return this.get().resolved() && this.get().get() instanceof EmptyMogram;
        }

        public boolean isToInstance() {
            return this.target.resolved() && !(this.target.get() instanceof EmptyMogram) ? this.target.get().level().equals(Level.M1) : this.isToInstance;
        }

        public void setToInstance(boolean toInstance) {
            this.isToInstance = toInstance;
        }

        public void instanceTypes(List<String> declarationTypes) {
            this.declarationTypes = declarationTypes;
        }

        public String toString() {
            return this.target.reference();
        }

        public void path(String path) {
            this.path = path;
        }

        public String path() {
            return this.path;
        }
    }

    public static class Expression
    implements Serializable {
        String value;

        public Expression(String value) {
            this.value = value;
        }

        public String get() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

