/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.model;

import io.intino.tara.model.Element;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramReference;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.Property;
import io.intino.tara.model.Rule;
import io.intino.tara.model.rules.Size;
import java.util.List;
import java.util.stream.Collectors;

public interface ElementContainer
extends Element {
    public String name();

    public ElementContainer container();

    default public void container(ElementContainer container) {
    }

    default public MogramRoot root() {
        return this instanceof MogramRoot ? (MogramRoot)this : this.container().root();
    }

    public List<Element> elements();

    public List<Mogram> components();

    public List<Mogram> mograms();

    public List<Mogram> siblings();

    public List<MogramReference> referenceComponents();

    default public void add(Element element, List<Rule<?>> rule) {
    }

    default public List<Mogram> component(String type) {
        return this.components().stream().filter(component -> type.equals(component.types().get(0)) || type.equals(component.shortType())).collect(Collectors.toList());
    }

    public List<Rule<?>> rulesOf(Element var1);

    default public Size sizeOf(Element component) {
        return (Size)this.rulesOf(component).stream().filter(r -> r instanceof Size).findAny().orElse(Size.MULTIPLE());
    }

    public <T extends Mogram> boolean contains(T var1);

    default public <T extends Mogram> void remove(T mogram) {
    }

    default public <T extends Property> void add(T ... property) {
    }
}

