/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.errorcollector;

import io.intino.tara.language.semantics.MessageProvider;
import io.intino.tara.language.semantics.errorcollector.SemanticIssue;
import io.intino.tara.model.Element;
import java.util.Objects;

public class SemanticException
extends Exception {
    private final transient SemanticIssue issue;

    public SemanticException(SemanticIssue notification) {
        this.issue = notification;
    }

    public SemanticIssue getIssue() {
        return this.issue;
    }

    @Override
    public String getMessage() {
        if (this.issue.key() == null) {
            return "";
        }
        return MessageProvider.message(this.issue.key(), this.issue.parameters().toArray());
    }

    public String[] getParameters() {
        return (String[])this.issue.parameters().stream().filter(Objects::nonNull).map(Object::toString).toArray(String[]::new);
    }

    public boolean isFatal() {
        return this.level().equals((Object)SemanticIssue.Level.ERROR);
    }

    public SemanticIssue.Level level() {
        return this.issue.level();
    }

    public String key() {
        return this.issue.key();
    }

    public Element[] origin() {
        return this.issue.origin();
    }
}

