/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints.property;

import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.NamedReference;
import io.intino.tara.model.PropertyDescription;
import java.util.List;

abstract class DescriptivePropertyConstraint
implements Constraint.Property {
    protected ParameterError error = ParameterError.NOT_FOUND;

    DescriptivePropertyConstraint() {
    }

    static PropertyDescription findProperty(List<PropertyDescription> props, String facet, String name, int position) {
        for (PropertyDescription prop : props) {
            if (prop.name().isEmpty() || !prop.name().equals(name)) continue;
            return prop;
        }
        return DescriptivePropertyConstraint.byPosition(props, facet, position);
    }

    private static PropertyDescription byPosition(List<PropertyDescription> props, String facet, int position) {
        return props.stream().filter(prop -> prop.name().isEmpty() && prop.facet().equals(facet) && prop.position() == position).findFirst().orElse(null);
    }

    boolean isNotGeneralization(Element element) {
        return element instanceof Mogram && !((Mogram)element).is(Annotation.Generalization) && !this.isInherited((Mogram)element);
    }

    private boolean isInherited(Mogram mogram) {
        NamedReference<Mogram> parent = mogram.parent();
        while (parent != null && parent.resolved()) {
            PropertyDescription parameter = DescriptivePropertyConstraint.findProperty(mogram.parent().get().parameters(), "", this.name(), this.position());
            if (parameter != null) {
                return true;
            }
            parent = mogram.parent();
        }
        return false;
    }

    protected static enum ParameterError {
        NOT_FOUND,
        RECOVERABLE_ERROR,
        RULE;

    }
}

