/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints.property;

import io.intino.tara.language.semantics.constraints.property.DescriptivePropertyConstraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticIssue;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Parametrized;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.Rule;
import io.intino.tara.model.rules.Size;
import io.intino.tara.processors.model.HasMogram;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class DescriptiveProperty
extends DescriptivePropertyConstraint {
    private final String name;
    private final Primitive type;
    private final String facet;
    private final int position;
    private final Level level;
    private final List<Rule> rules;
    private final Set<Annotation> annotations;

    public DescriptiveProperty(String name, Primitive type, String facet, int position, Level level, List<Rule> rules, List<Annotation> annotations) {
        this.name = name;
        this.type = type;
        this.facet = facet;
        this.position = position;
        this.level = level;
        this.rules = rules;
        this.annotations = new HashSet<Annotation>(annotations);
    }

    @Override
    public void check(Element element) throws SemanticException {
        if (element instanceof HasMogram) {
            return;
        }
        this.checkParameter(element, ((Parametrized)((Object)element)).parameters());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Primitive type() {
        return this.type;
    }

    @Override
    public String facet() {
        return this.facet;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public Level level() {
        return this.level;
    }

    @Override
    public List<Rule> rules() {
        return this.rules;
    }

    @Override
    public List<Annotation> annotations() {
        return List.copyOf(this.annotations);
    }

    private void checkParameter(Element element, List<PropertyDescription> parameters) throws SemanticException {
        PropertyDescription prop = DescriptiveProperty.findProperty(parameters, this.facet, this.name, this.position);
        if (prop == null) {
            if (this.size().isRequired() && (!(element instanceof Mogram) || this.isNotGeneralization(element))) {
                throw new SemanticException(new SemanticIssue(SemanticIssue.Level.RECOVERABLE_ERROR, "required.parameter.in.context", element, Arrays.asList(this.reference(element), this.type.getName(), this.name())));
            }
            return;
        }
        List<SemanticIssue> issues = this.notComplaintRules(prop).stream().map(r -> new SemanticIssue(r.level(), r.errorMessage() == null || r.errorMessage().isEmpty() ? "rule.not.complains" : r.errorMessage(), prop, r.errorParameters())).toList();
        if (!issues.isEmpty()) {
            throw new SemanticException(issues.get(0));
        }
    }

    private String reference(Element element) {
        Mogram m;
        if (element instanceof Mogram && !(m = (Mogram)element).name().isEmpty()) {
            return m.types().get(0);
        }
        return "";
    }

    private Size size() {
        return this.rules.stream().filter(r -> r instanceof Size).map(r -> (Size)r).findFirst().orElse(null);
    }

    private List<Rule> notComplaintRules(PropertyDescription prop) {
        return this.rules.stream().filter(r -> !r.accept(prop)).collect(Collectors.toList());
    }

    public String toString() {
        return "Parameter{" + String.valueOf(this.type) + "@" + this.name + "}";
    }
}

