/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints.component;

import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticIssue;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Rule;
import io.intino.tara.model.rules.Size;
import io.intino.tara.processors.Resolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public record Component(String type, List<Rule<?>> rules, List<Annotation> annotations) implements Constraint.Component
{
    @Override
    public void check(Element element) throws SemanticException {
        List<Mogram> notAccepted;
        if (!(element instanceof ElementContainer)) {
            return;
        }
        ElementContainer container = (ElementContainer)element;
        List<Mogram> components = this.filterByType(container);
        List<Mogram> accepted = this.acceptedComponents(components);
        if (!accepted.isEmpty()) {
            components.forEach(this::addFlags);
        }
        if (!(notAccepted = this.notAccepted(components, accepted)).isEmpty()) {
            this.error(notAccepted.get(0));
        } else {
            this.checkRequired(element, accepted);
        }
    }

    private List<Mogram> acceptedComponents(List<Mogram> components) {
        return components.stream().filter(component -> this.rules.stream().allMatch(r -> this.accept((Rule)r, components, (Mogram)component))).collect(Collectors.toList());
    }

    private boolean accept(Rule r, List<Mogram> components, Mogram component) {
        return r instanceof Size ? r.accept(components::size) : r.accept(component);
    }

    private List<Mogram> notAccepted(List<Mogram> components, List<Mogram> accepted) {
        return components.stream().filter(c -> !accepted.contains(c)).collect(Collectors.toList());
    }

    private void error(Mogram notAccepted) throws SemanticException {
        for (Rule<?> rule : this.rules) {
            if (this.accept(rule, notAccepted.container().components(), notAccepted)) continue;
            throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, rule.errorMessage(), notAccepted, rule.errorParameters()));
        }
    }

    private void checkRequired(Element element, List<Mogram> accepted) throws SemanticException {
        if (this.rules.get(0) instanceof Size && ((Size)this.rules.get(0)).isRequired() && !this.isAccepted(accepted, this.type())) {
            List<String> parameters = Collections.singletonList(this.type.replace(":", " on "));
            throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "required.type.in.context", element, parameters));
        }
    }

    private boolean isAccepted(List<Mogram> accepted, String type) {
        return accepted.stream().anyMatch(mogram -> Resolver.mainType(mogram).equals(type));
    }

    private void addFlags(Mogram mogram) {
        ArrayList<Annotation> flags = new ArrayList<Annotation>(mogram.annotations());
        this.annotations.forEach(flag -> {
            if (!flags.contains(flag)) {
                mogram.addAnnotations((Annotation)flag);
            }
            flags.add((Annotation)flag);
        });
    }

    private List<Mogram> filterByType(ElementContainer mogram) {
        return mogram.components().stream().filter(this::isCompatible).collect(Collectors.toList());
    }

    private boolean isCompatible(Mogram mogram) {
        return mogram.types().stream().anyMatch(type -> this.type.equals(type) || Resolver.shortType(this.type).equals(type)) || this.checkFacets(mogram);
    }

    private boolean checkFacets(Mogram mogram) {
        return mogram.appliedFacets().stream().anyMatch(facet -> facet.type().equals(Resolver.shortType(this.type)));
    }

    @Override
    public String toString() {
        return "Component{" + this.type + "}";
    }
}

