/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints.annotations;

import io.intino.tara.language.semantics.constraints.annotations.AnnotationChecker;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticIssue;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.rules.Size;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationCoherenceCheckerFactory {
    private static final Map<String, AnnotationChecker> checkers = new HashMap<String, AnnotationChecker>();

    private AnnotationCoherenceCheckerFactory() {
    }

    public static AnnotationChecker get(Object key) {
        return checkers.get(key.toString());
    }

    public static SemanticException error(Mogram mogram, List<String> flags) {
        return new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "reject.flag.combination", mogram, flags));
    }

    public static SemanticException error(String message, Mogram mogram) {
        return new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, message, mogram));
    }

    public static SemanticException error(String message, Mogram mogram, List<String> parameters) {
        return new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, message, mogram, parameters));
    }

    static {
        checkers.put(Annotation.Private.name().toLowerCase(), new PrivateChecker());
        checkers.put(Annotation.Feature.name().toLowerCase(), new FeatureChecker());
        checkers.put(Annotation.Component.name().toLowerCase(), new ComponentChecker());
    }

    private static class PrivateChecker
    implements AnnotationChecker {
        private PrivateChecker() {
        }

        @Override
        public void check(Mogram mogram) throws SemanticException {
            if (mogram.annotations().contains(Annotation.Final)) {
                throw AnnotationCoherenceCheckerFactory.error(mogram, Arrays.asList(Annotation.Final.name(), Annotation.Private.name()));
            }
        }
    }

    private static class FeatureChecker
    implements AnnotationChecker {
        private FeatureChecker() {
        }

        @Override
        public void check(Mogram mogram) throws SemanticException {
            if (mogram.level() == Level.M3) {
                throw AnnotationCoherenceCheckerFactory.error("m3.mogram.cannot.be", mogram, Collections.singletonList(Annotation.Feature.name()));
            }
        }
    }

    private static class ComponentChecker
    implements AnnotationChecker {
        private ComponentChecker() {
        }

        @Override
        public void check(Mogram mogram) throws SemanticException {
            if (!(mogram.container() instanceof MogramRoot)) {
                throw AnnotationCoherenceCheckerFactory.error("reject.component.annotation", mogram);
            }
            if (mogram.annotations().contains(Annotation.Feature)) {
                throw AnnotationCoherenceCheckerFactory.error(mogram, Arrays.asList(Annotation.Feature.name(), Annotation.Component.name()));
            }
            Size size = mogram.container().sizeOf(mogram);
            if (size == null) {
                return;
            }
            if (size.min() != 0 || size.max() != Integer.MAX_VALUE) {
                throw AnnotationCoherenceCheckerFactory.error("reject.root.component.size", mogram);
            }
        }
    }
}

