/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints;

import io.intino.tara.language.semantics.Assumption;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.constraints.FacetConstraint;
import io.intino.tara.language.semantics.constraints.FacetInstantiationConstraint;
import io.intino.tara.language.semantics.constraints.component.Component;
import io.intino.tara.language.semantics.constraints.component.OneOf;
import io.intino.tara.language.semantics.constraints.property.DescriptiveProperty;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticIssue;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Parametrized;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.Rule;
import io.intino.tara.processors.Resolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RuleFactory {
    private RuleFactory() {
    }

    public static Constraint.Component component(String type, List<Rule<?>> rules, Annotation ... flags) {
        return new Component(type, rules, Arrays.asList(flags));
    }

    @Deprecated
    public static Constraint.Component component(String type, Rule<?> rule, Annotation ... flags) {
        return new Component(type, Collections.singletonList(rule), Arrays.asList(flags));
    }

    public static Constraint.OneOf oneOf(List<Rule<?>> rules, Constraint.Component ... components) {
        return new OneOf(Arrays.asList(components), rules);
    }

    public static Constraint.Property property(String name, Primitive type, String facet, int position, Level level, List<Rule> rules, Annotation ... annotations) {
        return new DescriptiveProperty(name, type, facet, position, level, rules, Arrays.asList(annotations));
    }

    public static Constraint.Facet facet(String type, boolean terminal, String[] with, String[] without) {
        return RuleFactory.facet(type, terminal, false, with, without);
    }

    public static Constraint.Facet facet(String type, boolean terminal, boolean required, String[] with, String[] without) {
        return new FacetConstraint(type, terminal, required, with, without);
    }

    public static Constraint.FacetInstantiation facetInstantiation(String ... types) {
        return new FacetInstantiationConstraint(types);
    }

    public static Constraint.RejectOtherComponents rejectOtherComponents(final List<String> types) {
        return new Constraint.RejectOtherComponents(){

            @Override
            public void check(Element element) throws SemanticException {
                ElementContainer mogram = (ElementContainer)element;
                for (Mogram component : mogram.components()) {
                    if (RuleFactory.areCompatibles(component, types)) continue;
                    throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "reject.type.not.exists", component, Collections.singletonList(Resolver.mainType(component).replace(":", ""))));
                }
            }
        };
    }

    private static boolean areCompatibles(Mogram mogram, List<String> allowedTypes) {
        return mogram.types().stream().filter(Objects::nonNull).anyMatch(type -> allowedTypes.contains(type) || mogram.container() != null && RuleFactory.fromFacet(RuleFactory.containerFacets(mogram), type, allowedTypes)) || RuleFactory.checkFacet(mogram, allowedTypes) || RuleFactory.checkFacetInstance(mogram);
    }

    private static boolean checkFacetInstance(Mogram mogram) {
        return mogram.metaMograms().stream().anyMatch(m -> {
            Mogram mm;
            ElementContainer patt0$temp = mogram.container();
            return patt0$temp instanceof Mogram && (mm = (Mogram)patt0$temp).types().contains(m.facetPrescription().get().qualifiedName());
        });
    }

    public static Constraint.RejectOtherParameters rejectOtherParameters(final List<Constraint.Property> parameters) {
        return new Constraint.RejectOtherParameters(){

            @Override
            public void check(Element element) throws SemanticException {
                if (!(element instanceof Parametrized)) {
                    return;
                }
                Parametrized parametrized = (Parametrized)((Object)element);
                for (PropertyDescription parameter : parametrized.parameters()) {
                    if (this.isAcceptable(parameter, parameters)) continue;
                    throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "reject.other.parameter.in.context", parameter, Collections.singletonList(parameter.name().isEmpty() ? RuleFactory.anchorName(parameter) : parameter.name())));
                }
            }

            private boolean isAcceptable(PropertyDescription parameter, List<Constraint.Property> constraints) {
                return constraints.stream().anyMatch(constraint -> constraint.name().equals(parameter.name()) && this.hasFacet(constraint.facet(), parameter.container().appliedFacets()));
            }

            private boolean hasFacet(String requiredFacet, List<Facet> facets) {
                return requiredFacet.isEmpty() || facets.stream().anyMatch(facet -> facet.type().equals(requiredFacet));
            }
        };
    }

    private static String anchorName(PropertyDescription parameter) {
        return parameter.values().isEmpty() ? "0" : parameter.values().get(0).toString();
    }

    public static Constraint.RejectOtherFacets rejectOtherFacets(final List<Constraint.Facet> facets) {
        return new Constraint.RejectOtherFacets(){

            @Override
            public void check(Element element) throws SemanticException {
                if (!(element instanceof Mogram)) {
                    return;
                }
                Mogram mogram = (Mogram)element;
                for (Facet facet : mogram.appliedFacets()) {
                    if (this.isAcceptable(facets, facet)) continue;
                    throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "reject.other.facet.in.context", facet, Collections.singletonList(facet.type())));
                }
            }

            private boolean isAcceptable(List<Constraint.Facet> facets2, Facet facet) {
                return facets2.stream().anyMatch(a -> a.type().equals(facet.fullType()));
            }
        };
    }

    private static List<Facet> containerFacets(Mogram mogram) {
        List<Facet> list;
        ElementContainer container = mogram.container();
        if (container instanceof Mogram) {
            Mogram m = (Mogram)container;
            list = m.appliedFacets();
        } else {
            list = List.of();
        }
        return list;
    }

    private static boolean fromFacet(List<Facet> facets, String nodeType, List<String> types) {
        return RuleFactory.facetComponent(facets, nodeType, types) || RuleFactory.asFacet(facets, nodeType.split(":")[0]);
    }

    private static boolean facetComponent(List<Facet> facets, String nodeType, List<String> types) {
        return facets.stream().anyMatch(facet -> types.contains(nodeType));
    }

    private static boolean asFacet(List<Facet> facets, String facet) {
        return facets.stream().anyMatch(a -> a.type().equals(facet));
    }

    private static boolean checkFacet(Mogram mogram, List<String> types) {
        List<String> shortTypes = types.stream().map(Resolver::shortType).toList();
        return mogram.appliedFacets().stream().anyMatch(facet -> shortTypes.contains(facet.type()));
    }

    public static Constraint name() {
        return new Constraint.Name(){

            @Override
            public void check(Element element) throws SemanticException {
                if (!(element instanceof Mogram)) {
                    return;
                }
                Mogram mogram = (Mogram)element;
                if (mogram.name().isEmpty()) {
                    throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "required.name", element, Collections.emptyList()));
                }
            }
        };
    }

    public static Assumption isFeature() {
        return new Assumption.Feature(){

            @Override
            public void assume(Mogram mogram) {
                if (!mogram.annotations().contains(Annotation.Feature)) {
                    mogram.addAnnotations(Annotation.Feature);
                }
                RuleFactory.propagateAnnotations(mogram, Annotation.Feature);
            }
        };
    }

    public static Assumption isComponent() {
        return new Assumption.Component(){

            @Override
            public void assume(Mogram mogram) {
            }
        };
    }

    private static void propagateAnnotations(Mogram mogram, Annotation tag) {
        for (Mogram component : mogram.components()) {
            if (component.annotations().contains(tag)) continue;
            component.addAnnotations(tag);
            if (component.equals(mogram)) continue;
            RuleFactory.propagateAnnotations(component, tag);
        }
    }
}

