/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints;

import io.intino.tara.model.EmptyMogram;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import java.io.File;

public class PrimitiveTypeCompatibility {
    private PrimitiveTypeCompatibility() {
    }

    public static boolean checkCompatiblePrimitives(Primitive type, Primitive inferredType, boolean multiple) {
        return type.equals(inferredType) || PrimitiveTypeCompatibility.emptyInfersEmptyList(type, inferredType, multiple) || PrimitiveTypeCompatibility.integerInfersInteger(type, inferredType) || PrimitiveTypeCompatibility.booleanOrFunctionInfersBoolean(type, inferredType) || PrimitiveTypeCompatibility.nativeOrEmptyInfersObject(type, inferredType) || PrimitiveTypeCompatibility.stringInfersString(type, inferredType) || PrimitiveTypeCompatibility.integerInfersDouble(type, inferredType) || PrimitiveTypeCompatibility.integerInfersLong(type, inferredType) || PrimitiveTypeCompatibility.stringFunctionOrEmptyInfersDate(type, inferredType) || PrimitiveTypeCompatibility.stringFunctionOrEmptyInfersInstant(type, inferredType) || PrimitiveTypeCompatibility.stringInfersTime(type, inferredType) || PrimitiveTypeCompatibility.nativeOrEmptyInfersNative(type, inferredType) || PrimitiveTypeCompatibility.emptyInfersReference(type, inferredType) || PrimitiveTypeCompatibility.referenceInfersWord(type, inferredType) || PrimitiveTypeCompatibility.stringOrEmptyInfersFile(type, inferredType);
    }

    private static boolean stringInfersTime(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.STRING) || inferredType.equals(Primitive.EMPTY)) && type.equals(Primitive.TIME);
    }

    private static boolean stringOrEmptyInfersFile(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.STRING) || inferredType.equals(Primitive.EMPTY) || inferredType.equals(Primitive.FUNCTION)) && type.equals(Primitive.RESOURCE);
    }

    private static boolean booleanOrFunctionInfersBoolean(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.BOOLEAN) || inferredType.equals(Primitive.FUNCTION) || inferredType.equals(Primitive.EMPTY)) && type.equals(Primitive.BOOLEAN);
    }

    private static boolean nativeOrEmptyInfersObject(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.FUNCTION) || inferredType.equals(Primitive.EMPTY)) && type.equals(Primitive.OBJECT);
    }

    private static boolean stringInfersString(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.STRING) || inferredType.equals(Primitive.FUNCTION) || inferredType.equals(Primitive.EMPTY)) && type.equals(Primitive.STRING);
    }

    private static boolean emptyInfersReference(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.EMPTY) || inferredType.equals(Primitive.FUNCTION)) && type.equals(Primitive.REFERENCE);
    }

    private static boolean nativeOrEmptyInfersNative(Primitive type, Primitive inferredType) {
        return inferredType.equals(Primitive.FUNCTION) && type.equals(Primitive.FUNCTION);
    }

    private static boolean emptyInfersEmptyList(Primitive type, Primitive inferredType, boolean multiple) {
        return inferredType.equals(Primitive.EMPTY) && !type.equals(Primitive.REFERENCE) && multiple;
    }

    private static boolean stringFunctionOrEmptyInfersDate(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.STRING) || inferredType.equals(Primitive.FUNCTION) || inferredType.equals(Primitive.EMPTY)) && type.equals(Primitive.DATE);
    }

    private static boolean stringFunctionOrEmptyInfersInstant(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.STRING) || inferredType.equals(Primitive.FUNCTION) || inferredType.equals(Primitive.EMPTY)) && type.equals(Primitive.INSTANT);
    }

    private static boolean integerInfersDouble(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.INTEGER) || inferredType.equals(Primitive.FUNCTION) || inferredType.equals(Primitive.EMPTY)) && type.equals(Primitive.DOUBLE);
    }

    private static boolean integerInfersInteger(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.INTEGER) || inferredType.equals(Primitive.FUNCTION) || inferredType.equals(Primitive.EMPTY)) && type.equals(Primitive.INTEGER);
    }

    private static boolean integerInfersLong(Primitive type, Primitive inferredType) {
        return (inferredType.equals(Primitive.INTEGER) || inferredType.equals(Primitive.FUNCTION) || inferredType.equals(Primitive.EMPTY)) && type.equals(Primitive.LONG);
    }

    private static boolean referenceInfersWord(Primitive type, Primitive inferredType) {
        return type.equals(Primitive.WORD) && inferredType.equals(Primitive.REFERENCE);
    }

    public static Primitive inferType(Object value) {
        if (value == null || value instanceof EmptyMogram) {
            return Primitive.EMPTY;
        }
        if (value instanceof String) {
            return Primitive.STRING;
        }
        if (value instanceof Primitive.Reference || value instanceof Mogram) {
            return Primitive.REFERENCE;
        }
        if (value instanceof Double) {
            return Primitive.DOUBLE;
        }
        if (value instanceof Boolean) {
            return Primitive.BOOLEAN;
        }
        if (value instanceof Integer) {
            return Primitive.INTEGER;
        }
        if (value instanceof Long) {
            return Primitive.LONG;
        }
        if (value instanceof File) {
            return Primitive.RESOURCE;
        }
        if (value instanceof Primitive.Expression) {
            return Primitive.FUNCTION;
        }
        if (value instanceof Primitive.MethodReference) {
            return Primitive.FUNCTION;
        }
        return null;
    }
}

