/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints;

import io.intino.tara.language.semantics.Annotations;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.constraints.annotations.AnnotationChecker;
import io.intino.tara.language.semantics.constraints.annotations.AnnotationCoherenceCheckerFactory;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticIssue;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.EmptyMogram;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramReference;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.NamedReference;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.Rule;
import io.intino.tara.model.Valued;
import io.intino.tara.model.rules.CustomRule;
import io.intino.tara.model.rules.property.PropertyCustomRule;
import io.intino.tara.model.rules.property.WordRule;
import io.intino.tara.processors.model.Model;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;

public class GlobalConstraints {
    private static boolean isOverridden(Property prop, Property parentProp) {
        return parentProp.type() != null && parentProp.type().equals(prop.type()) && parentProp.name() != null && parentProp.name().equals(prop.name());
    }

    private static void error(String message, Element element, List<?> parameters) throws SemanticException {
        throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, message, element, parameters));
    }

    private static void error(String message, Element element) throws SemanticException {
        throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, message, element));
    }

    public Constraint[] all() {
        return new Constraint[]{this.parentConstraint(), this.referencesInInstances(), this.invalidMogramAnnotations(), this.duplicatedAnnotations(), this.duplicatedInstances(), this.annotationCoherence(), this.checkProperties(), this.mogramName(), this.duplicatedFacets()};
    }

    private Constraint parentConstraint() {
        return element -> {
            if (!(element instanceof Mogram)) {
                return;
            }
            Mogram mogram = (Mogram)element;
            NamedReference<Mogram> parent = mogram.parent();
            if (parent == null || !parent.resolved()) {
                return;
            }
            String type = GlobalConstraints.mainType(mogram);
            String parentType = GlobalConstraints.mainType(parent.get());
            if (!parentType.equals(type.split(":")[0]) && !parentType.equals(type)) {
                GlobalConstraints.error("reject.parent.different.type", mogram, Arrays.asList(parentType, type));
            }
            if (parent.get().level() == Level.M1) {
                GlobalConstraints.error("reject.sub.of.instance", mogram);
            }
        };
    }

    private static String mainType(Mogram mogram) {
        return mogram.types().get(0);
    }

    private Constraint referencesInInstances() {
        return element -> {
            if (!(element instanceof Mogram)) {
                return;
            }
            Mogram mogram = (Mogram)element;
            if (mogram.level() != Level.M1) {
                return;
            }
            MogramReference reference = mogram.referenceComponents().stream().findFirst().orElse(null);
            if (reference != null) {
                GlobalConstraints.error("reject.reference.in.m1.mograms", mogram, Collections.emptyList());
            }
        };
    }

    private Constraint duplicatedInstances() {
        return element -> {
            if (!(element instanceof Mogram)) {
                return;
            }
            Mogram mogram = (Mogram)element;
            if (mogram.level() != Level.M1 || mogram.isAnonymous()) {
                return;
            }
            for (Mogram sibling : mogram.siblings()) {
                if (!mogram.name().equals(sibling.name())) continue;
                GlobalConstraints.error("reject.duplicate.entries", mogram, List.of(mogram.name(), mogram.container() instanceof Model ? GlobalConstraints.getName(mogram.source()) : mogram.container().name()));
            }
        };
    }

    private Constraint duplicatedAnnotations() {
        return element -> {
            if (!(element instanceof Mogram)) {
                return;
            }
            Mogram mogram = (Mogram)element;
            HashSet<String> tags = new HashSet<String>();
            for (Annotation annotation : mogram.annotations()) {
                if (tags.add(annotation.name())) continue;
                GlobalConstraints.error("reject.duplicate.annotation", mogram, Arrays.asList(annotation, GlobalConstraints.mainType(mogram)));
            }
            tags.clear();
            for (Annotation flag : mogram.annotations()) {
                if (tags.add(flag.name())) continue;
                GlobalConstraints.error("reject.duplicate.annotation", mogram, Arrays.asList(flag, GlobalConstraints.mainType(mogram) + " " + mogram.name()));
            }
        };
    }

    private Constraint invalidMogramAnnotations() {
        return element -> {
            List<Annotation> availableAnnotations;
            if (!(element instanceof Mogram)) {
                return;
            }
            Mogram mogram = (Mogram)element;
            if (mogram.annotations().isEmpty()) {
                return;
            }
            if (mogram.container() instanceof MogramRoot) {
                availableAnnotations = new ArrayList<Annotation>(Annotations.forRootMogram());
                if (mogram.facetPrescription() != null) {
                    availableAnnotations.remove(Annotation.Required);
                }
            } else {
                availableAnnotations = Annotations.forMogramComponent();
            }
            for (Annotation tag : mogram.annotations()) {
                if (availableAnnotations.contains(tag)) continue;
                GlobalConstraints.error("reject.invalid.annotation", mogram, Arrays.asList(tag.name(), GlobalConstraints.mainType(mogram)));
            }
        };
    }

    private static String getName(URI source) {
        String path = source.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private Constraint annotationCoherence() {
        return element -> {
            if (!(element instanceof Mogram)) {
                return;
            }
            Mogram mogram = (Mogram)element;
            for (Annotation a : mogram.annotations()) {
                this.checkAnnotationConstrains(a.name(), mogram);
            }
        };
    }

    private void checkAnnotationConstrains(String annotation, Mogram mogram) throws SemanticException {
        AnnotationChecker aClass = AnnotationCoherenceCheckerFactory.get(annotation.toLowerCase());
        if (aClass != null) {
            aClass.check(mogram);
        }
    }

    private Constraint checkProperties() {
        return element -> {
            if (!(element instanceof Mogram)) {
                return;
            }
            Mogram mogram = (Mogram)element;
            this.checkDuplicatesBetween(mogram.components(), mogram.properties());
            this.checkDuplicatesBetween(mogram.referenceComponents().stream().map(m -> m.target().get()).filter(Objects::nonNull).toList(), mogram.properties());
            this.checkDuplicates(mogram.properties());
            this.checkDuplicates(mogram.parameters());
            for (Property variable : mogram.properties()) {
                this.checkProperty(variable);
            }
        };
    }

    private void checkDuplicatesBetween(List<Mogram> components, List<Property> variables) throws SemanticException {
        if (variables == null) {
            return;
        }
        for (Property var : variables) {
            if (!components.stream().anyMatch(c -> var.name() != null && var.name().equals(c.name()))) continue;
            GlobalConstraints.error("reject.duplicated.name.between.properties.and.components", var, Collections.singletonList(var.name()));
        }
    }

    private void checkDuplicates(List<? extends Valued> values) throws SemanticException {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Valued valued : values) {
            if (valued.name() == null || valued.name().isEmpty() || names.add(valued.name())) continue;
            GlobalConstraints.error("reject.duplicated.valued", valued, List.of(valued.getClass().getSimpleName().contains("Parameter") ? "parameter" : "property", valued.name()));
        }
    }

    private void checkProperty(Property prop) throws SemanticException {
        Rule notAccepted;
        List<Object> values = prop.values();
        if (prop.container().level() == Level.M1) {
            GlobalConstraints.error("reject.property.in.m1.mogram", prop);
        } else if (Primitive.FUNCTION.equals(prop.type()) && prop.rules() == null) {
            GlobalConstraints.error("reject.nonexistent.property.rule", prop, Collections.singletonList(prop.type().javaName()));
        } else if (!(values.isEmpty() || values.get(0) instanceof EmptyMogram || this.hasExpressionValue(values) || (notAccepted = (Rule)prop.rules().stream().filter(r -> !r.accept(prop)).findFirst().orElse(null)) == null)) {
            String message = notAccepted.errorMessage();
            GlobalConstraints.error(message == null || message.isEmpty() ? "custom.rule.class.not.comply" : message, prop, notAccepted.errorParameters());
        }
        if (prop.type().equals(Primitive.WORD) && prop.rule(WordRule.class) == null && prop.rule(CustomRule.class) == null) {
            GlobalConstraints.error("reject.invalid.word.names", prop);
        }
        this.checkAnnotations(prop);
        if (prop.name() != null && Character.isUpperCase(prop.name().charAt(0))) {
            this.warning("warning.property.name.starts.uppercase", prop);
        }
    }

    private void checkAnnotations(Property prop) throws SemanticException {
        Property parentVariable;
        if (prop.annotations().contains(Annotation.Private) && !this.isInGeneralization(prop) && prop.values().isEmpty()) {
            GlobalConstraints.error("reject.private.property.without.default.value", prop, Collections.singletonList(prop.name()));
        }
        if (prop.annotations().contains(Annotation.Reactive) && prop.type().equals(Primitive.FUNCTION)) {
            GlobalConstraints.error("reject.invalid.annotation", prop, Arrays.asList(Annotation.Reactive.name(), prop.name()));
        }
        if (!Primitive.WORD.equals(prop.type()) && prop.annotations().contains(Annotation.Reactive) && prop.rules() != null && prop.rules() instanceof PropertyCustomRule) {
            if (prop.values().isEmpty() || this.hasExpressionValue(prop)) {
                GlobalConstraints.error("reject.reactive.property.with.rules", prop, Arrays.asList(Annotation.Reactive.name(), prop.name()));
            } else if (prop.rules() instanceof PropertyCustomRule || !this.hasExpressionValue(prop)) {
                GlobalConstraints.error("reject.reactive.with.no.expression.value", prop, Arrays.asList(Annotation.Reactive.name(), prop.name()));
            }
        }
        if ((parentVariable = this.findParentVariable(prop)) != null) {
            this.checkParentVariables(prop, parentVariable);
        }
    }

    private boolean hasExpressionValue(Property variable) {
        return variable.values().get(0) instanceof Primitive.Expression || variable.values().get(0) instanceof Primitive.MethodReference;
    }

    private void checkParentVariables(Property variable, Property parentVariable) throws SemanticException {
        if (parentVariable.annotations().contains(Annotation.Reactive) != variable.annotations().contains(Annotation.Reactive)) {
            GlobalConstraints.error("reject.parent.property.annotations", variable);
        }
    }

    private Property findParentVariable(Property variable) {
        Mogram mogram = variable.container();
        if (mogram == null) {
            return null;
        }
        NamedReference<Mogram> parent = mogram.parent();
        if (parent == null) {
            return null;
        }
        while (parent != null && parent.resolved()) {
            for (Property parentVar : parent.get().properties()) {
                if (!GlobalConstraints.isOverridden(variable, parentVar)) continue;
                return parentVar;
            }
            parent = parent.get().parent();
        }
        return null;
    }

    private boolean isInGeneralization(Property variable) {
        return variable.container() != null && variable.container().is(Annotation.Generalization);
    }

    private boolean hasExpressionValue(List<Object> values) {
        return !values.isEmpty() && (values.get(0) instanceof Primitive.Expression || values.get(0) instanceof Primitive.MethodReference);
    }

    private Constraint mogramName() {
        return element -> {
            if (!(element instanceof Mogram)) {
                return;
            }
            Mogram mogram = (Mogram)element;
            if (mogram.level() != Level.M1 && mogram.isAnonymous()) {
                GlobalConstraints.error("concept.with.no.name", mogram);
            } else if (mogram.level() == Level.M1) {
                return;
            }
            if (mogram.container() != null && mogram.container() != null && !mogram.isAnonymous() && mogram.name().equals(mogram.container().name())) {
                GlobalConstraints.error("reject.container.and.component.namesake", mogram);
            }
        };
    }

    private Constraint duplicatedFacets() {
        return element -> {
            if (!(element instanceof Mogram)) {
                return;
            }
            Mogram mogram = (Mogram)element;
            HashSet<String> facets = new HashSet<String>();
            for (Facet facet : mogram.appliedFacets()) {
                if (facets.add(facet.type())) continue;
                GlobalConstraints.error("reject.duplicated.facet", facet);
            }
        };
    }

    private void warning(String message, Element element) throws SemanticException {
        throw new SemanticException(new SemanticIssue(SemanticIssue.Level.WARNING, message, element));
    }
}

