/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints;

import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticIssue;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FacetInstantiationConstraint
implements Constraint.FacetInstantiation {
    private final List<String> types;

    FacetInstantiationConstraint(String ... types) {
        this.types = Arrays.asList(types);
    }

    @Override
    public List<String> types() {
        return this.types;
    }

    @Override
    public void check(Element element) throws SemanticException {
        Mogram mogram = (Mogram)element;
        List<Mogram> facetMograms = mogram.mograms().stream().filter(m -> m.types().stream().anyMatch(this.types::contains)).toList();
        for (Mogram facetMogram : facetMograms) {
            List<String> targetTypes = facetMogram.metaMograms().stream().map(m -> m.facetPrescription().get().qualifiedName()).toList();
            for (String type : this.types) {
                if (facetMogram.types().contains(type)) continue;
                throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "reject.incompatible.facet.prescription.in.context", facetMogram, Collections.singletonList(String.join((CharSequence)", ", this.types))));
            }
            if (facetMogram.facetPrescription() != null) continue;
            ElementContainer container = facetMogram.container();
            if (container instanceof Mogram) {
                Mogram cm = (Mogram)container;
                if (!((Mogram)container).types().stream().anyMatch(targetTypes::contains)) continue;
                facetMogram.facetPrescription(cm);
                cm.addApplicableFacet(facetMogram);
                continue;
            }
            throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "reject.mogram.without.required.facet.target", facetMogram, Collections.singletonList(String.join((CharSequence)", ", this.types))));
        }
    }

    public String toString() {
        return "Facet Instantiation " + String.join((CharSequence)",", this.types);
    }
}

