/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints;

import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticIssue;
import io.intino.tara.model.Element;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Mogram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FacetConstraint
implements Constraint.Facet {
    private final String type;
    private final boolean terminal;
    private final boolean required;
    private final String[] with;
    private final String[] withOut;
    private final List<Constraint> constraints;

    FacetConstraint(String type, boolean terminal, boolean required, String[] with, String[] withOut) {
        this.type = type;
        this.terminal = terminal;
        this.required = required;
        this.with = (String[])with.clone();
        this.withOut = (String[])withOut.clone();
        this.constraints = new ArrayList<Constraint>();
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String[] with() {
        return this.with;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String[] withOut() {
        return this.withOut;
    }

    public boolean terminal() {
        return this.terminal;
    }

    @Override
    public List<Constraint> constraints() {
        return this.constraints;
    }

    @Override
    public Constraint.Facet has(Constraint ... requires) {
        this.constraints.addAll(Arrays.asList(requires));
        return this;
    }

    @Override
    public void check(Element element) throws SemanticException {
        Mogram mogram = (Mogram)element;
        Facet facet = FacetConstraint.findFacet(mogram, this.type);
        if (facet == null && this.required) {
            throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "reject.mogram.with.required.facet.not.found", mogram, Collections.singletonList(this.type)));
        }
        if (facet == null) {
            return;
        }
        boolean hasType = this.is(mogram.types(), this.with);
        boolean hasIncompatibles = this.isAny(mogram.types(), this.withOut);
        if (!hasType || hasIncompatibles || !this.checkFacetConstrains(mogram)) {
            if (!hasType) {
                throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "reject.facet.with.no.constrains.in.context", facet, Arrays.asList(this.with)));
            }
            if (hasIncompatibles) {
                throw new SemanticException(new SemanticIssue(SemanticIssue.Level.ERROR, "reject.incompatible.facets.in.context", facet, Collections.singletonList(String.join((CharSequence)", ", Arrays.asList(this.withOut)))));
            }
        }
    }

    public static Facet findFacet(Mogram mogram, String type) {
        return mogram.appliedFacets().stream().filter(facet -> type.equals(facet.fullType())).findFirst().orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean is(List<String> nodeTypes, String[] constraints) {
        List<String> types = nodeTypes.stream().map(s -> s.split(":")[0]).toList();
        if (constraints == null) return true;
        if (!Arrays.stream(constraints).allMatch(types::contains)) return false;
        return true;
    }

    private boolean isAny(List<String> nodeTypes, String[] constraints) {
        List<String> types = nodeTypes.stream().map(s -> s.split(":")[0]).toList();
        return constraints != null && Arrays.stream(constraints).anyMatch(aType -> types.contains(aType) && !aType.equals(this.type));
    }

    private boolean checkFacetConstrains(Mogram mogram) throws SemanticException {
        ArrayList<SemanticException> messages = new ArrayList<SemanticException>();
        for (Constraint c : this.constraints) {
            try {
                c.check(mogram);
            }
            catch (SemanticException e) {
                if (e.level() == SemanticIssue.Level.ERROR) {
                    throw e;
                }
                messages.add(e);
            }
        }
        if (!messages.isEmpty()) {
            throw (SemanticException)messages.get(0);
        }
        return true;
    }

    public String toString() {
        return "Facet " + this.type;
    }
}

