/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics;

import io.intino.tara.language.semantics.Assumption;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.constraints.ConstraintHelper;
import io.intino.tara.language.semantics.constraints.RuleFactory;
import io.intino.tara.model.Level;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Context {
    private final String[] types;
    private final Level level;
    private final List<Constraint> constraints = new ArrayList<Constraint>();
    private final List<Assumption> assumptions = new ArrayList<Assumption>();

    public Context(String[] types, Level level, Constraint[] globalConstrains) {
        this.types = (String[])types.clone();
        this.level = level;
        Collections.addAll(this.constraints, globalConstrains);
    }

    public String[] types() {
        return Arrays.copyOf(this.types, this.types.length);
    }

    public Level level() {
        return this.level;
    }

    public List<Constraint> constraints() {
        return this.constraints;
    }

    public List<Assumption> assumptions() {
        return this.assumptions;
    }

    public Context assume(Assumption ... assumptions) {
        this.assumptions.addAll(Arrays.asList(assumptions));
        return this;
    }

    public Context has(Constraint ... constraints) {
        this.constraints().addAll(Arrays.asList(constraints));
        return this.rejectOthers();
    }

    private Context rejectOthers() {
        this.constraints().add(RuleFactory.rejectOtherComponents(ConstraintHelper.componentConstrains(this.constraints())));
        this.constraints().add(RuleFactory.rejectOtherParameters(ConstraintHelper.parameterConstrains(this.constraints())));
        this.constraints().add(RuleFactory.rejectOtherFacets(ConstraintHelper.facetConstrains(this.constraints())));
        return this;
    }
}

