/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara;

import io.intino.tara.Language;
import io.intino.tara.language.semantics.Assumption;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.Context;
import io.intino.tara.language.semantics.constraints.GlobalConstraints;
import io.intino.tara.model.Level;
import io.intino.tara.processors.Resolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Tara
implements Language {
    private final Map<String, Context> rulesCatalog = new HashMap<String, Context>();
    private final List<String> lexicon = new ArrayList<String>();

    protected RuleTransaction def(String qualifiedName) {
        return context -> {
            this.rulesCatalog.put(qualifiedName, context);
            return context;
        };
    }

    protected Context context(Level level, String ... types) {
        return new Context(types, level, new GlobalConstraints().all());
    }

    @Override
    public Level level(String qualifiedName) {
        if (qualifiedName == null || !this.rulesCatalog.containsKey(qualifiedName)) {
            return null;
        }
        return this.rulesCatalog.get(qualifiedName).level();
    }

    @Override
    public Map<String, Context> catalog() {
        return this.rulesCatalog;
    }

    @Override
    public List<Constraint> constraints(String qualifiedName) {
        if (qualifiedName == null || !this.rulesCatalog.containsKey(qualifiedName)) {
            return null;
        }
        return Collections.unmodifiableList(this.rulesCatalog.get(qualifiedName).constraints());
    }

    @Override
    public List<Assumption> assumptions(String qualifiedName) {
        if (qualifiedName == null || !this.rulesCatalog.containsKey(qualifiedName)) {
            return null;
        }
        return Collections.unmodifiableList(this.rulesCatalog.get(qualifiedName).assumptions());
    }

    @Override
    public List<String> types(String qualifiedName) {
        if (qualifiedName == null || !this.rulesCatalog.containsKey(qualifiedName)) {
            return null;
        }
        return Arrays.asList(this.rulesCatalog.get(qualifiedName).types());
    }

    @Override
    public String[] lexicon() {
        if (!this.lexicon.isEmpty()) {
            return this.lexicon.toArray(new String[0]);
        }
        return this.calculateLexicon();
    }

    private String[] calculateLexicon() {
        this.lexicon.addAll(this.collectTokens());
        return this.lexicon.toArray(new String[0]);
    }

    private Collection<String> collectTokens() {
        Set<String> collect = this.rulesCatalog.keySet().stream().filter(qn -> !Resolver.shortType(qn).isEmpty()).map(t -> {
            String shortType = Resolver.shortType(t);
            return shortType.contains(":") ? shortType.substring(0, shortType.indexOf(":")) : shortType;
        }).collect(Collectors.toSet());
        for (Context context : this.rulesCatalog.values()) {
            collect.addAll(context.constraints().stream().filter(c -> c instanceof Constraint.Facet).map(c -> ((Constraint.Facet)c).type()).collect(Collectors.toSet()));
        }
        return collect;
    }

    public static interface RuleTransaction {
        public Context with(Context var1);
    }
}

