/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;

public interface Source {
    public URI uri();

    public Charset charset();

    public InputStream content() throws IOException;

    public boolean dirty();

    public static class StringSource
    implements Source {
        private final String name;
        private final String content;

        public StringSource(String name, String content) {
            this.name = name;
            this.content = content;
        }

        @Override
        public URI uri() {
            return URI.create(this.name);
        }

        @Override
        public Charset charset() {
            return Charset.defaultCharset();
        }

        @Override
        public InputStream content() {
            return new ByteArrayInputStream(this.content.getBytes());
        }

        public String stringContent() {
            return this.content;
        }

        @Override
        public boolean dirty() {
            return false;
        }
    }
}

