/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints;

import io.intino.tara.Resolver;
import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramContainer;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.Parametrized;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.model.rules.variable.VariableRule;
import io.intino.tara.language.semantics.Assumption;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.constraints.FacetConstraint;
import io.intino.tara.language.semantics.constraints.MetaFacetConstraint;
import io.intino.tara.language.semantics.constraints.component.Component;
import io.intino.tara.language.semantics.constraints.component.OneOf;
import io.intino.tara.language.semantics.constraints.parameter.PrimitiveParameter;
import io.intino.tara.language.semantics.constraints.parameter.ReferenceParameter;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RuleFactory {
    private RuleFactory() {
    }

    public static Constraint.Component component(String type, List<Rule> rules, Tag ... flags) {
        return new Component(type, rules, Arrays.asList(flags));
    }

    @Deprecated
    public static Constraint.Component component(String type, Rule rule, Tag ... flags) {
        return new Component(type, Collections.singletonList(rule), Arrays.asList(flags));
    }

    public static Constraint.OneOf oneOf(List<Rule> rules, Constraint.Component ... components) {
        return new OneOf(Arrays.asList(components), rules);
    }

    public static Constraint.Parameter parameter(String name, Primitive type, String facet, Size size, int position, String scope, VariableRule rule, Tag ... tags) {
        return new PrimitiveParameter(name, type, facet, size, position, scope, rule, Arrays.asList(tags));
    }

    public static Constraint.Parameter parameter(String name, String type, String facet, Size size, int position, String scope, VariableRule rule, Tag ... tags) {
        return new ReferenceParameter(name, type, facet, size, position, scope, rule, Arrays.asList(tags));
    }

    public static Constraint.Facet facet(String type, boolean terminal, String[] with, String[] without) {
        return RuleFactory.facet(type, terminal, false, with, without);
    }

    public static Constraint.Facet facet(String type, boolean terminal, boolean required, String[] with, String[] without) {
        return new FacetConstraint(type, terminal, required, with, without);
    }

    public static Constraint.MetaFacet metaFacet(String type, String ... with) {
        return new MetaFacetConstraint(type, with);
    }

    public static Constraint.ComponentNotFound rejectOtherComponents(final List<String> types) {
        return new Constraint.ComponentNotFound(){

            @Override
            public void check(Element element) throws SemanticException {
                MogramContainer node = (MogramContainer)element;
                for (Mogram component : node.components()) {
                    if (RuleFactory.areCompatibles(component, types)) continue;
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.type.not.exists", component, Collections.singletonList(component.type().replace(":", ""))));
                }
            }
        };
    }

    private static boolean areCompatibles(Mogram mogram, List<String> allowedTypes) {
        return mogram.types().stream().anyMatch(type -> type != null && (allowedTypes.contains(type) || mogram.container() != null && RuleFactory.fromFacet(mogram.container().appliedFacets(), type, allowedTypes))) || RuleFactory.checkFacet(mogram, allowedTypes);
    }

    public static Constraint.RejectOtherParameters rejectOtherParameters(final List<Constraint.Parameter> parameters) {
        return new Constraint.RejectOtherParameters(){

            @Override
            public void check(Element element) throws SemanticException {
                Parametrized parametrized = (Parametrized)((Object)element);
                for (Parameter parameter : parametrized.parameters()) {
                    if (this.isAcceptable(parameter, parameters)) continue;
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.other.parameter.in.context", parameter, Collections.singletonList(parameter.name())));
                }
            }

            private boolean isAcceptable(Parameter parameter, List<Constraint.Parameter> parameters2) {
                return parameters2.stream().anyMatch(constraint -> constraint.name().equals(parameter.name()) && this.hasFacet(constraint.facet(), parameter.container().appliedFacets()));
            }

            private boolean hasFacet(String requiredFacet, List<Facet> facets) {
                return requiredFacet.isEmpty() || facets.stream().anyMatch(facet -> facet.type().equals(requiredFacet));
            }
        };
    }

    public static Constraint.RejectOtherFacets rejectOtherFacets(final List<Constraint.Facet> facets) {
        return new Constraint.RejectOtherFacets(){

            @Override
            public void check(Element element) throws SemanticException {
                Mogram mogram = (Mogram)element;
                for (Facet facet : mogram.appliedFacets()) {
                    if (this.isAcceptable(facets, facet)) continue;
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.other.facet.in.context", facet, Collections.singletonList(facet.type())));
                }
            }

            private boolean isAcceptable(List<Constraint.Facet> facets2, Facet facet) {
                return facets2.stream().anyMatch(a -> a.type().equals(facet.fullType()));
            }
        };
    }

    private static boolean fromFacet(List<Facet> facets, String nodeType, List<String> types) {
        return RuleFactory.facetComponent(facets, nodeType, types) || RuleFactory.asFacet(facets, nodeType.split(":")[0]);
    }

    private static boolean facetComponent(List<Facet> facets, String nodeType, List<String> types) {
        return facets.stream().anyMatch(facet -> types.contains(nodeType));
    }

    private static boolean asFacet(List<Facet> facets, String facet) {
        return facets.stream().anyMatch(a -> a.type().equals(facet));
    }

    private static boolean checkFacet(Mogram mogram, List<String> types) {
        List shortTypes = types.stream().map(Resolver::shortType).collect(Collectors.toList());
        return mogram.appliedFacets().stream().anyMatch(facet -> shortTypes.contains(facet.type()));
    }

    public static Constraint name() {
        return new Constraint.Name(){

            @Override
            public void check(Element element) throws SemanticException {
                Mogram mogram = (Mogram)element;
                if (!mogram.isReference() && mogram.name().isEmpty()) {
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "required.name", element, Collections.emptyList()));
                }
            }
        };
    }

    public static Constraint.TerminalVariableRedefinition redefine(final String name, final String superType) {
        return new Constraint.TerminalVariableRedefinition(){

            @Override
            public void check(Element element) throws SemanticException {
                Mogram mogram = (Mogram)element;
                if (!mogram.flags().contains((Object)Tag.Instance)) {
                    for (Variable variable : mogram.variables()) {
                        if (!name.equals(variable.name())) continue;
                        return;
                    }
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "required.terminal.variable.redefine", mogram, Arrays.asList(name, superType)));
                }
            }
        };
    }

    public static Assumption isFacet() {
        return new Assumption.Facet(){

            @Override
            public void assume(Mogram mogram) {
                if (!mogram.flags().contains((Object)Tag.Facet)) {
                    mogram.addFlags(Tag.Facet);
                }
                if (!mogram.flags().contains((Object)Tag.Terminal)) {
                    mogram.addFlags(Tag.Terminal);
                }
            }
        };
    }

    public static Assumption isFacetInstance() {
        return new Assumption.FacetInstance(){

            @Override
            public void assume(Mogram mogram) {
                if (!mogram.flags().contains((Object)Tag.FacetInstance)) {
                    mogram.addFlags(Tag.FacetInstance);
                }
            }
        };
    }

    public static Assumption isFeature() {
        return new Assumption.Feature(){

            @Override
            public void assume(Mogram mogram) {
                if (!mogram.flags().contains((Object)Tag.Feature)) {
                    mogram.addFlags(Tag.Feature);
                }
                RuleFactory.propagateFlags(mogram, Tag.Feature);
            }
        };
    }

    public static Assumption isTerminal() {
        return new Assumption.Terminal(){

            @Override
            public void assume(Mogram mogram) {
                if (mogram.isReference()) {
                    return;
                }
                if (!mogram.flags().contains((Object)Tag.Terminal)) {
                    mogram.addFlags(Tag.Terminal);
                }
                mogram.variables().stream().filter(variable -> !variable.flags().contains((Object)Tag.Terminal)).forEach(variable -> variable.addFlags(Tag.Terminal));
                RuleFactory.propagateFlags(mogram, Tag.Terminal);
            }
        };
    }

    public static Assumption isVolatile() {
        return new Assumption.Volatile(){

            @Override
            public void assume(Mogram mogram) {
                if (mogram.isReference()) {
                    return;
                }
                if (!mogram.flags().contains((Object)Tag.Volatile)) {
                    mogram.addFlags(Tag.Volatile);
                }
                RuleFactory.propagateFlags(mogram, Tag.Volatile);
            }
        };
    }

    public static Assumption isComponent() {
        return new Assumption.Component(){

            @Override
            public void assume(Mogram mogram) {
                if (!mogram.flags().contains((Object)Tag.Component)) {
                    mogram.addFlags(Tag.Component);
                }
            }
        };
    }

    public static Assumption isInstance() {
        return new Assumption.Instance(){

            @Override
            public void assume(Mogram mogram) {
                if (!mogram.flags().contains((Object)Tag.Instance)) {
                    mogram.addFlags(Tag.Instance);
                }
                mogram.variables().stream().filter(variable -> !variable.flags().contains((Object)Tag.Instance)).forEach(variable -> variable.addFlags(Tag.Instance));
                RuleFactory.propagateFlags(mogram, Tag.Instance);
            }
        };
    }

    public static Assumption stashNodeName(final String stashNodeName) {
        return new Assumption.StashNodeName(){

            @Override
            public String stashNodeName() {
                return stashNodeName;
            }

            @Override
            public void assume(Mogram mogram) {
                mogram.stashNodeName(stashNodeName);
            }
        };
    }

    private static void propagateFlags(Mogram mogram, Tag tag) {
        for (Mogram component : mogram.components()) {
            if (component.isReference() || component.flags().contains((Object)tag)) continue;
            component.addFlags(tag);
            if (component.equals(mogram)) continue;
            RuleFactory.propagateFlags(component, tag);
        }
    }
}

