/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.model.rules.variable;

import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Primitive;
import io.intino.tara.language.model.rules.variable.VariableRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ReferenceRule
implements VariableRule<List<Primitive.Reference>> {
    private final List<String> allowedReferences = new ArrayList<String>();

    public ReferenceRule(Collection<String> allowedReferences) {
        for (String ref : allowedReferences) {
            if (!this.allowedReferences.contains(ref)) {
                this.allowedReferences.add(ref);
            }
            Arrays.stream(ref.split(":")).filter(r -> !this.allowedReferences.contains(r)).forEach(this.allowedReferences::add);
        }
    }

    @Override
    public boolean accept(List<Primitive.Reference> values, String metric) {
        return this.accept(values);
    }

    @Override
    public boolean accept(List<Primitive.Reference> values) {
        for (Primitive.Reference v : values) {
            Mogram reference = v.reference();
            for (String type : reference.types()) {
                if (!this.allowedReferences.contains(type) && !this.allowedReferences.contains(type.split(":")[0])) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> allowedReferences() {
        return new ArrayList<String>(this.allowedReferences);
    }

    public void setAllowedReferences(List<String> allowedReferences) {
        this.allowedReferences.clear();
        this.allowedReferences.addAll(allowedReferences);
    }

    public String toString() {
        return String.join((CharSequence)", ", this.allowedReferences);
    }

    @Override
    public List<Object> errorParameters() {
        return Collections.singletonList(this.toString());
    }

    @Override
    public String errorMessage() {
        return "reject.parameter.reference";
    }
}

