package io.intino.tara.language.model;

import java.util.Collections;
import java.util.List;

public interface Mogram extends Parametrized, MogramContainer {

	String ANONYMOUS = "anonymous@";

	String name();

	void name(String name);

	String type();

	String qualifiedName();

	Mogram container();

	boolean isSub();

	boolean isFacet();

	boolean isMetaFacet();

	default List<FacetConstraint> facetConstraints() {
		return Collections.emptyList();
	}

	List<Facet> appliedFacets();

	boolean is(Tag tag);

	boolean into(Tag tag);

	boolean isAbstract();

	boolean isTerminal();

	List<Tag> annotations();

	List<Tag> flags();

	void addAnnotations(Tag... annotations);

	void addFlags(Tag... flags);

	Mogram parent();

	String parentName();

	boolean isAnonymous();

	List<String> types();

	List<String> secondaryTypes();

	void type(String type);

	void stashNodeName(String name);

	default List<String> metaTypes() {
		return Collections.emptyList();
	}

	default void metaTypes(List<String> types) {

	}

	Mogram resolve();

	boolean isReference();

	List<Variable> variables();

	Mogram targetOfReference();

	List<Mogram> children();

	List<Mogram> subs();

	default void addUses(List<String> imports) {
	}

	default <T extends Mogram> void addChild(T node) {
	}

	default void applyFacets(Facet... facets) {
	}

	@Override
	String toString();

	@Override
	boolean equals(Object obj);

	@Override
	int hashCode();

	interface FacetConstraint {
		String name();

		Mogram node();
	}
}