/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.errorcollector;

import io.intino.tara.language.model.Element;
import io.intino.tara.language.semantics.MessageProvider;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SemanticException
extends Exception {
    private final transient SemanticNotification notification;

    public SemanticException(SemanticNotification notification) {
        this.notification = notification;
    }

    public SemanticNotification getNotification() {
        return this.notification;
    }

    @Override
    public String getMessage() {
        if (this.notification.key() == null) {
            return "";
        }
        return MessageProvider.message(this.notification.key(), this.notification.parameters().toArray());
    }

    public String[] getParameters() {
        List<String> parameters = this.notification.parameters().stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        return parameters.toArray(new String[parameters.size()]);
    }

    public boolean isFatal() {
        return this.level().equals((Object)SemanticNotification.Level.ERROR);
    }

    public SemanticNotification.Level level() {
        return this.notification.level();
    }

    public String key() {
        return this.notification.key();
    }

    public Element[] origin() {
        return this.notification.origin();
    }
}

