package io.intino.tara.language.semantics.constraints.parameter;

import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;

import java.util.List;

abstract class ParameterConstraint implements Constraint.Parameter {

	enum ParameterError {
		TYPE, NOT_FOUND, RECOVERABLE_ERROR, RULE, SIZE
	}

	protected ParameterError error = ParameterError.TYPE;

	static io.intino.tara.language.model.Parameter findParameter(List<io.intino.tara.language.model.Parameter> parameters, String facet, String name, int position) {
		for (io.intino.tara.language.model.Parameter parameter : parameters)
			if (!parameter.name().isEmpty() && parameter.name().equals(name)) return parameter;
		return byPosition(parameters, facet, position);
	}

	private static io.intino.tara.language.model.Parameter byPosition(List<io.intino.tara.language.model.Parameter> parameters, String facet, int position) {
		for (io.intino.tara.language.model.Parameter parameter : parameters) {
			if (parameter.name().isEmpty() && parameter.facet().equals(facet) && parameter.position() == position)
				return parameter;
		}
		return null;
	}

	boolean isNotAbstractNode(Element element) {
		return element instanceof Mogram && !((Mogram) element).isAbstract() && !isInherited((Mogram) element);
	}

	private boolean isInherited(Mogram mogram) {
		Mogram parent = mogram.parent();
		while (parent != null) {
			final io.intino.tara.language.model.Parameter parameter = findParameter(mogram.parent().parameters(), "", name(), position());
			if (parameter != null) return true;
			parent = mogram.parent();
		}
		return false;
	}


	protected abstract void error(Element element, io.intino.tara.language.model.Parameter parameter, ParameterError errorType) throws SemanticException;
}
