package io.intino.tara.language.model;

import io.intino.tara.Language;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.model.rules.variable.VariableRule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Variable extends Valued, Cloneable {

	String name();

	Primitive type();

	List<Tag> flags();

	boolean isReference();

	boolean isMultiple();

	VariableRule rule();

	void rule(VariableRule rule);

	String scope();

	Size size();

	void size(Size size);

	boolean isOverridden();

	void name(String name);

	Mogram container();

	Mogram targetOfReference();

	default void container(Mogram container) {
	}

	void type(Primitive type);

	void addFlags(Tag... flags);

	boolean isTerminal();

	boolean isFinal();

	boolean isPrivate();

	boolean isInherited();

	void overriden(boolean overriden);

	default void values(List<Object> values) {
	}

	String defaultMetric();

	void defaultMetric(String defaultExtension);

	String getUID();

	default Language language() {
		return nodeRoot() == null ? null : nodeRoot().language();
	}

	default MogramRoot nodeRoot() {
		Mogram container = container();
		while (container != null && !(container instanceof MogramRoot))
			container = container.container();
		return (MogramRoot) container;
	}

	default Variable cloneIt(Mogram container) {
		return null;
	}

	class NativeCounter {
		private static Map<String, Integer> map = new HashMap<>();

		public synchronized static int next(MogramContainer container, String name) {
			final String key = calculatePackage(container) + "." + name;
			map.put(key, map.containsKey(key) ? map.get(key) + 1 : 0);
			return map.get(key);
		}

		private static String calculatePackage(MogramContainer container) {
			final Mogram mogramContainer = (Mogram) firstNamedContainer(container);
			return mogramContainer == null ? "" : mogramContainer.qualifiedName().replace("$", ".").replace("#", ".").toLowerCase();
		}

		private static MogramContainer firstNamedContainer(MogramContainer container) {
			List<MogramContainer> containers = collectStructure(container);
			MogramContainer candidate = null;
			for (MogramContainer mogramContainer : containers) {
				if (mogramContainer instanceof Mogram && !((Mogram) mogramContainer).isAnonymous()) candidate = mogramContainer;
				else if (mogramContainer instanceof Mogram) break;
				else candidate = mogramContainer;
			}
			return candidate;
		}

		private static List<MogramContainer> collectStructure(MogramContainer container) {
			List<MogramContainer> containers = new ArrayList<>();
			MogramContainer current = container;
			while (current != null && !(current instanceof MogramRoot)) {
				containers.add(0, current);
				current = current.container();
			}
			return containers;
		}

	}


}
