parser grammar TaraGrammar;
options { tokenVocab=TaraLexer; }


root: NEWLINE* dslDeclaration? imports? (mogram NEWLINE*)* EOF;

dslDeclaration : DSL headerReference NEWLINE*;

imports : anImport+;
anImport: USE headerReference NEWLINE+;

doc: DOC+;

mogram: doc? signature body?;

signature: ((SUB mogramConstraint* signatureProperties? IDENTIFIER facets*) |
			(metaidentifier mogramConstraint* signatureProperties? IDENTIFIER? facets* parent?)) with? tags;

body: NEW_LINE_INDENT ((property | mogram | propertyInit | mogramReference) NEWLINE+)+ DEDENT;

parent : EXTENDS identifierReference;

signatureProperties : LEFT_PARENTHESIS (signatureProperty (COMMA signatureProperty)*)? RIGHT_PARENTHESIS;
signatureProperty: (IDENTIFIER EQUALS)? value;

facets : AS facet+;

facet: metaidentifier signatureProperties?;

value : identifierReference+
		| stringValue+
		| tupleValue+
		| booleanValue+
		| identifierReference+
		| integerValue+ measureUnit?
		| doubleValue+ measureUnit?
		| expression+
		| methodReference+
		| EMPTY;

mogramReference : HAS mogramConstraint* identifierReference tags;
with: WITH identifierReference (COMMA identifierReference)*;
property : doc? VAR propertyType size? mogramConstraint? IDENTIFIER (EQUALS value measureUnit?)? flags? bodyValue?;

bodyValue : NEW_LINE_INDENT (stringValue | expression) NEWLINE? DEDENT;

propertyType: INT_TYPE
			| LONG_TYPE
            | DOUBLE_TYPE
            | BOOLEAN_TYPE
            | STRING_TYPE
            | FUNCTION_TYPE
            | OBJECT_TYPE
            | WORD
            | DATE_TYPE
            | INSTANT_TYPE
            | TIME_TYPE
            | RESOURCE
            | identifierReference;

mogramConstraint : COLON ruleValue;

ruleValue    : (LEFT_CURLY (IDENTIFIER+ | ((range | stringValue) measureUnit?) | measureUnit) RIGHT_CURLY) | (identifierReference);

range        : (doubleValue | integerValue | STAR) (DOT DOT (doubleValue | integerValue | STAR))?;

size		 : LEFT_SQUARE sizeRange? RIGHT_SQUARE;
sizeRange 	 : NATURAL_VALUE | listRange;
listRange    : (NATURAL_VALUE | STAR) DOT DOT (NATURAL_VALUE | STAR);


methodReference : AT identifierReference;

stringValue  : NEWLINE? (STRING);
booleanValue : BOOLEAN_VALUE;
tupleValue   : stringValue COLON doubleValue;
integerValue : NATURAL_VALUE | NEGATIVE_VALUE;
doubleValue  : (NATURAL_VALUE | NEGATIVE_VALUE | DOUBLE_VALUE) SCIENCE_NOT?;

measureUnit       : IDENTIFIER | MEASURE_VALUE;

expression   : NEWLINE? (EXPRESSION_BEGIN CHARACTER* EXPRESSION_END);

tags: flags? annotations?;

annotations: INTO annotation+;
annotation: COMPONENT | FEATURE | ENCLOSED;

flags: IS flag+;
flag: ABSTRACT | TERMINAL | COMPONENT | PRIVATE | FEATURE | ENCLOSED | FINAL | CONCEPT | REACTIVE | VOLATILE | DECORABLE | REQUIRED | DIVINE;

propertyInit : IDENTIFIER ((EQUALS value) | bodyValue);

headerReference: hierarchy* IDENTIFIER;

identifierReference: hierarchy* IDENTIFIER;
hierarchy: IDENTIFIER (DOT | PLUS);
metaidentifier: IDENTIFIER;