/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints.flags;

import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.semantics.constraints.flags.FlagChecker;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AnnotationCoherenceCheckerFactory {
    private static final Map<String, FlagChecker> checkers = new HashMap<String, FlagChecker>();

    private AnnotationCoherenceCheckerFactory() {
    }

    public static FlagChecker get(Object key) {
        return checkers.get(key.toString());
    }

    public static SemanticException error(Mogram mogram) {
        return new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.flag.combination", mogram, Arrays.asList(Tag.Concept, Tag.Feature)));
    }

    static {
        checkers.put(Tag.Feature.name().toLowerCase(), new FeatureChecker());
    }

    private static class FeatureChecker
    implements FlagChecker {
        private FeatureChecker() {
        }

        @Override
        public void check(Mogram mogram) throws SemanticException {
            if ("Concept".equals(mogram.type())) {
                throw AnnotationCoherenceCheckerFactory.error(mogram);
            }
        }
    }
}

