/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints.component;

import io.intino.tara.Resolver;
import io.intino.tara.language.model.Element;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramContainer;
import io.intino.tara.language.model.Rule;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.rules.MogramRule;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Component
implements Constraint.Component {
    private final String type;
    private final List<Rule> rules;
    private final List<Tag> annotations;

    public Component(String type, List<Rule> rules, List<Tag> annotations) {
        this.type = type;
        this.rules = rules;
        this.annotations = annotations;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public MogramRule compositionRule() {
        return this.rules.stream().filter(r -> r instanceof MogramRule).findFirst().orElse(null);
    }

    @Override
    public List<Rule> rules() {
        return this.rules;
    }

    @Override
    public List<Tag> annotations() {
        return this.annotations;
    }

    @Override
    public void check(Element element) throws SemanticException {
        List<Mogram> notAccepted;
        Mogram container = (Mogram)element;
        if (container.isReference()) {
            return;
        }
        List<Mogram> components = this.filterByType(container);
        List<Mogram> accepted = this.acceptedComponents(components);
        if (!accepted.isEmpty()) {
            components.forEach(this::addFlags);
        }
        if (!(notAccepted = this.notAccepted(components, accepted)).isEmpty()) {
            this.error(notAccepted.get(0));
        } else {
            this.checkRequired(element, accepted);
        }
    }

    private List<Mogram> acceptedComponents(List<Mogram> components) {
        return components.stream().filter(component -> this.rules.stream().allMatch(r -> this.accept((Rule)r, components, (Mogram)component))).collect(Collectors.toList());
    }

    private boolean accept(Rule r, List<Mogram> components, Mogram component) {
        return r instanceof Size ? r.accept(components) : r.accept(component);
    }

    private List<Mogram> notAccepted(List<Mogram> components, List<Mogram> accepted) {
        return components.stream().filter(c -> !accepted.contains(c)).collect(Collectors.toList());
    }

    private void error(Mogram notAccepted) throws SemanticException {
        for (Rule rule : this.rules) {
            if (this.accept(rule, notAccepted.container().components(), notAccepted)) continue;
            throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, rule.errorMessage(), notAccepted, rule.errorParameters()));
        }
    }

    private void checkRequired(Element element, List<Mogram> accepted) throws SemanticException {
        if (this.rules.get(0) instanceof Size && ((Size)this.rules.get(0)).isRequired() && !this.isAccepted(accepted, this.type())) {
            String message = "required.type.in.context";
            List<String> parameters = Collections.singletonList(this.type.replace(":", " on "));
            throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, message, element, parameters));
        }
    }

    private boolean isAccepted(List<Mogram> accepted, String type) {
        for (Mogram mogram : accepted) {
            if (!mogram.type().equals(type)) continue;
            return true;
        }
        return false;
    }

    private void addFlags(Mogram mogram) {
        ArrayList<Tag> flags = new ArrayList<Tag>(mogram.flags());
        for (Tag flag : this.annotations) {
            if (!flags.contains((Object)flag)) {
                mogram.addFlags(flag);
            }
            flags.add(flag);
        }
    }

    private List<Mogram> filterByType(MogramContainer node) {
        return node.components().stream().filter(this::isCompatibles).collect(Collectors.toList());
    }

    private boolean isCompatibles(Mogram mogram) {
        for (String nodeType : mogram.types()) {
            if (nodeType == null || !nodeType.equals(this.type) && !nodeType.equals(Resolver.shortType(this.type))) continue;
            return true;
        }
        return this.checkFacets(mogram);
    }

    private boolean checkFacets(Mogram mogram) {
        for (Facet facet : mogram.appliedFacets()) {
            if (!facet.type().equals(Resolver.shortType(this.type))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Component{" + this.type + "}";
    }
}

